"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IncludeFeatureStatesField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../../../common/constants");
var _policy_requests = require("../../../../../../services/http/policy_requests");
var _feature_states_form_field = require("../../../../../feature_states_form_field");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IncludeFeatureStatesField = ({
  policy,
  onUpdate
}) => {
  const {
    config = {}
  } = policy;
  const {
    error: errorLoadingFeatures,
    isLoading: isLoadingFeatures,
    data: featuresResponse
  } = (0, _policy_requests.useLoadFeatures)();
  const featuresOptions = (0, _react.useMemo)(() => {
    const features = (featuresResponse === null || featuresResponse === void 0 ? void 0 : featuresResponse.features) || [];
    return features.map(feature => feature.name);
  }, [featuresResponse]);
  const selectedOptions = (0, _react.useMemo)(() => {
    var _config$featureStates;
    return config === null || config === void 0 ? void 0 : (_config$featureStates = config.featureStates) === null || _config$featureStates === void 0 ? void 0 : _config$featureStates.map(feature => ({
      label: feature
    }));
  }, [config.featureStates]);
  const isFeatureStatesToggleEnabled = config.featureStates !== undefined && !config.featureStates.includes(_constants.FEATURE_STATES_NONE_OPTION);
  const onFeatureStatesToggleChange = event => {
    const {
      checked
    } = event.target;
    onUpdate({
      featureStates: checked ? [] : [_constants.FEATURE_STATES_NONE_OPTION]
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.includeFeatureStatesDescriptionTitle",
      defaultMessage: "Include feature state"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.includeFeatureStatesDescription",
      defaultMessage: "Includes the configuration, history, and other data stored in Elasticsearch by a feature such as Elasticsearch security."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "featureStatesToggle",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.policyIncludeFeatureStatesLabel",
      defaultMessage: "Include feature state from"
    }),
    checked: isFeatureStatesToggleEnabled,
    onChange: onFeatureStatesToggleChange
  })), isFeatureStatesToggleEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !errorLoadingFeatures ? /*#__PURE__*/_react.default.createElement(_feature_states_form_field.FeatureStatesFormField, {
    isLoadingFeatures: isLoadingFeatures,
    featuresOptions: featuresOptions,
    selectedOptions: selectedOptions,
    onUpdateFormSettings: onUpdate
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.errorLoadingFeatureStatesLabel",
      defaultMessage: "There was an error loading the list of feature states"
    })
  })));
};
exports.IncludeFeatureStatesField = IncludeFeatureStatesField;