"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPreviewDataResponseSchema = exports.getPreviewDataParamsSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _schema = require("../../schema");
var _common = require("../../schema/common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPreviewDataParamsSchema = exports.getPreviewDataParamsSchema = t.type({
  body: t.intersection([t.type({
    indicator: _schema.indicatorSchema,
    range: t.type({
      start: t.number,
      end: t.number
    })
  }), t.partial({
    objective: _schema.objectiveSchema,
    instanceId: t.string,
    groupBy: t.string,
    remoteName: t.string,
    groupings: t.record(t.string, t.unknown)
  })])
});
const getPreviewDataResponseSchema = exports.getPreviewDataResponseSchema = t.array(t.intersection([t.type({
  date: _common.dateType,
  sliValue: t.union([t.number, t.null])
}), t.partial({
  events: t.type({
    good: t.number,
    bad: t.number,
    total: t.number
  })
})]));