"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformGenerator = void 0;
var _sloSchema = require("@kbn/slo-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TransformGenerator {
  buildCommonRuntimeMappings(slo) {
    return {
      'slo.id': {
        type: 'keyword',
        script: {
          source: `emit('${slo.id}')`
        }
      },
      'slo.revision': {
        type: 'long',
        script: {
          source: `emit(${slo.revision})`
        }
      }
    };
  }
  buildDescription(slo) {
    return `Rolled-up SLI data for SLO: ${slo.name} [id: ${slo.id}, revision: ${slo.revision}]`;
  }
  buildCommonGroupBy(slo, sourceIndexTimestampField = '@timestamp', extraGroupByFields = {}) {
    let fixedInterval = '1m';
    if (_sloSchema.timeslicesBudgetingMethodSchema.is(slo.budgetingMethod)) {
      fixedInterval = slo.objective.timesliceWindow.format();
    }
    const groups = [slo.groupBy].flat().filter(group => !!group);
    const groupings = !groups.includes(_sloSchema.ALL_VALUE) && groups.length ? groups.reduce((acc, field) => {
      return {
        ...acc,
        [`slo.groupings.${field}`]: {
          terms: {
            field
          }
        }
      };
    }, {}) : {};
    return {
      'slo.id': {
        terms: {
          field: 'slo.id'
        }
      },
      'slo.revision': {
        terms: {
          field: 'slo.revision'
        }
      },
      ...groupings,
      ...extraGroupByFields,
      // @timestamp field defined in the destination index
      '@timestamp': {
        date_histogram: {
          field: sourceIndexTimestampField,
          // timestamp field defined in the source index
          fixed_interval: fixedInterval
        }
      }
    };
  }
  buildSettings(slo, sourceIndexTimestampField = '@timestamp') {
    return {
      frequency: slo.settings.frequency.format(),
      sync_field: sourceIndexTimestampField,
      // timestamp field defined in the source index
      sync_delay: slo.settings.syncDelay.format()
    };
  }
}
exports.TransformGenerator = TransformGenerator;