"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindSLOGroups = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _slo_settings = require("./slo_settings");
var _queries = require("../utils/queries");
var _errors = require("../errors");
var _constants = require("../../common/constants");
var _transform_generators = require("./transform_generators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE = 1;
const MAX_PER_PAGE = 5000;
function toPagination(params) {
  const page = Number(params.page);
  const perPage = Number(params.perPage);
  if (!isNaN(perPage) && perPage > MAX_PER_PAGE) {
    throw new _errors.IllegalArgumentError(`perPage limit set to ${MAX_PER_PAGE}`);
  }
  return {
    page: !isNaN(page) && page >= 1 ? page : DEFAULT_PAGE,
    perPage: !isNaN(perPage) && perPage >= 1 ? perPage : _constants.DEFAULT_SLO_GROUPS_PAGE_SIZE
  };
}
class FindSLOGroups {
  constructor(esClient, soClient, logger, spaceId) {
    this.esClient = esClient;
    this.soClient = soClient;
    this.logger = logger;
    this.spaceId = spaceId;
  }
  async execute(params) {
    var _params$groupsFilter, _params$kqlQuery, _params$filters, _parsedFilters$filter, _parsedFilters$must_n, _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4, _response$aggregation5, _response$aggregation6;
    const pagination = toPagination(params);
    const groupBy = params.groupBy;
    const groupsFilter = [(_params$groupsFilter = params.groupsFilter) !== null && _params$groupsFilter !== void 0 ? _params$groupsFilter : []].flat();
    const kqlQuery = (_params$kqlQuery = params.kqlQuery) !== null && _params$kqlQuery !== void 0 ? _params$kqlQuery : '';
    const filters = (_params$filters = params.filters) !== null && _params$filters !== void 0 ? _params$filters : '';
    let parsedFilters = {};
    try {
      parsedFilters = JSON.parse(filters);
    } catch (e) {
      this.logger.error(`Failed to parse filters: ${e.message}`);
    }
    const indices = await (0, _slo_settings.getListOfSummaryIndices)(this.soClient, this.esClient);
    const hasSelectedTags = groupBy === 'slo.tags' && groupsFilter.length > 0;
    const response = await (0, _queries.typedSearch)(this.esClient, {
      index: indices,
      size: 0,
      query: {
        bool: {
          filter: [{
            term: {
              spaceId: this.spaceId
            }
          }, (0, _transform_generators.getElasticsearchQueryOrThrow)(kqlQuery), ...((_parsedFilters$filter = parsedFilters.filter) !== null && _parsedFilters$filter !== void 0 ? _parsedFilters$filter : [])],
          must_not: [...((_parsedFilters$must_n = parsedFilters.must_not) !== null && _parsedFilters$must_n !== void 0 ? _parsedFilters$must_n : [])]
        }
      },
      body: {
        aggs: {
          groupBy: {
            terms: {
              field: groupBy,
              size: 10000,
              ...(hasSelectedTags && {
                include: groupsFilter
              })
            },
            aggs: {
              worst: {
                top_hits: {
                  sort: {
                    errorBudgetRemaining: {
                      order: 'asc'
                    }
                  },
                  _source: {
                    includes: ['sliValue', 'status', 'slo.id', 'slo.instanceId', 'slo.name']
                  },
                  size: 1
                }
              },
              violated: {
                filter: {
                  term: {
                    status: 'VIOLATED'
                  }
                }
              },
              healthy: {
                filter: {
                  term: {
                    status: 'HEALTHY'
                  }
                }
              },
              degrading: {
                filter: {
                  term: {
                    status: 'DEGRADING'
                  }
                }
              },
              noData: {
                filter: {
                  term: {
                    status: 'NO_DATA'
                  }
                }
              },
              bucket_sort: {
                bucket_sort: {
                  sort: [{
                    _key: {
                      order: 'asc'
                    }
                  }],
                  from: (pagination.page - 1) * pagination.perPage,
                  size: pagination.perPage
                }
              }
            }
          },
          distinct_items: {
            cardinality: {
              field: groupBy
            }
          }
        }
      }
    });
    const total = (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : (_response$aggregation3 = _response$aggregation2.distinct_items) === null || _response$aggregation3 === void 0 ? void 0 : _response$aggregation3.value) !== null && _response$aggregation !== void 0 ? _response$aggregation : 0;
    const results = (_response$aggregation4 = (_response$aggregation5 = response.aggregations) === null || _response$aggregation5 === void 0 ? void 0 : (_response$aggregation6 = _response$aggregation5.groupBy) === null || _response$aggregation6 === void 0 ? void 0 : _response$aggregation6.buckets.reduce((acc, bucket) => {
      var _bucket$worst, _bucket$worst$hits, _bucket$worst$hits$hi, _bucket$doc_count, _bucket$violated, _bucket$healthy, _bucket$degrading, _bucket$noData;
      const sliDocument = (_bucket$worst = bucket.worst) === null || _bucket$worst === void 0 ? void 0 : (_bucket$worst$hits = _bucket$worst.hits) === null || _bucket$worst$hits === void 0 ? void 0 : (_bucket$worst$hits$hi = _bucket$worst$hits.hits[0]) === null || _bucket$worst$hits$hi === void 0 ? void 0 : _bucket$worst$hits$hi._source;
      if (String(bucket.key).endsWith('.temp') && groupBy === '_index') {
        return acc;
      }
      return [...acc, {
        group: bucket.key,
        groupBy,
        summary: {
          total: (_bucket$doc_count = bucket.doc_count) !== null && _bucket$doc_count !== void 0 ? _bucket$doc_count : 0,
          worst: sliDocument,
          violated: (_bucket$violated = bucket.violated) === null || _bucket$violated === void 0 ? void 0 : _bucket$violated.doc_count,
          healthy: (_bucket$healthy = bucket.healthy) === null || _bucket$healthy === void 0 ? void 0 : _bucket$healthy.doc_count,
          degrading: (_bucket$degrading = bucket.degrading) === null || _bucket$degrading === void 0 ? void 0 : _bucket$degrading.doc_count,
          noData: (_bucket$noData = bucket.noData) === null || _bucket$noData === void 0 ? void 0 : _bucket$noData.doc_count
        }
      }];
    }, [])) !== null && _response$aggregation4 !== void 0 ? _response$aggregation4 : [];
    return _sloSchema.findSLOGroupsResponseSchema.encode({
      page: pagination.page,
      perPage: pagination.perPage,
      total,
      results
    });
  }
}
exports.FindSLOGroups = FindSLOGroups;