"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindSLO = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _lodash = require("lodash");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE = 1;
const DEFAULT_PER_PAGE = 25;
const MAX_PER_PAGE = 5000;
class FindSLO {
  constructor(repository, summarySearchClient) {
    this.repository = repository;
    this.summarySearchClient = summarySearchClient;
  }
  async execute(params) {
    var _params$kqlQuery, _params$filters;
    const summaryResults = await this.summarySearchClient.search((_params$kqlQuery = params.kqlQuery) !== null && _params$kqlQuery !== void 0 ? _params$kqlQuery : '', (_params$filters = params.filters) !== null && _params$filters !== void 0 ? _params$filters : '', toSort(params), toPagination(params));
    const localSloDefinitions = await this.repository.findAllByIds(summaryResults.results.filter(summaryResult => !summaryResult.remote).map(summaryResult => summaryResult.sloId));
    return _sloSchema.findSLOResponseSchema.encode({
      page: summaryResults.page,
      perPage: summaryResults.perPage,
      total: summaryResults.total,
      results: mergeSloWithSummary(localSloDefinitions, summaryResults.results)
    });
  }
}
exports.FindSLO = FindSLO;
function mergeSloWithSummary(localSloDefinitions, summaryResults) {
  const localSloDefinitionsMap = (0, _lodash.keyBy)(localSloDefinitions, sloDefinition => sloDefinition.id);
  const localSummaryList = summaryResults.filter(summaryResult => !!localSloDefinitionsMap[summaryResult.sloId]).map(summaryResult => ({
    ...localSloDefinitionsMap[summaryResult.sloId],
    instanceId: summaryResult.instanceId,
    summary: summaryResult.summary,
    groupings: summaryResult.groupings
  }));
  const remoteSummaryList = summaryResults.filter(summaryResult => !!summaryResult.remote).map(summaryResult => ({
    ...summaryResult.remote.slo,
    instanceId: summaryResult.instanceId,
    summary: summaryResult.summary,
    groupings: summaryResult.groupings,
    remote: {
      remoteName: summaryResult.remote.remoteName,
      kibanaUrl: summaryResult.remote.kibanaUrl
    }
  }));
  return [...localSummaryList, ...remoteSummaryList];
}
function toPagination(params) {
  const page = Number(params.page);
  const perPage = Number(params.perPage);
  if (!isNaN(perPage) && perPage > MAX_PER_PAGE) {
    throw new _errors.IllegalArgumentError(`perPage limit set to ${MAX_PER_PAGE}`);
  }
  return {
    page: !isNaN(page) && page >= 1 ? page : DEFAULT_PAGE,
    perPage: !isNaN(perPage) && perPage >= 0 ? perPage : DEFAULT_PER_PAGE
  };
}
function toSort(params) {
  var _params$sortBy, _params$sortDirection;
  return {
    field: (_params$sortBy = params.sortBy) !== null && _params$sortBy !== void 0 ? _params$sortBy : 'status',
    direction: (_params$sortDirection = params.sortDirection) !== null && _params$sortDirection !== void 0 ? _params$sortDirection : 'asc'
  };
}