"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSloRouteRepository = void 0;
var _elasticsearch = require("@elastic/elasticsearch");
var _boom = require("@hapi/boom");
var _sloSchema = require("@kbn/slo-schema");
var _services = require("../../services");
var _fetch_historical_summary = require("../../services/fetch_historical_summary");
var _find_slo_definitions = require("../../services/find_slo_definitions");
var _get_burn_rates = require("../../services/get_burn_rates");
var _get_diagnosis = require("../../services/get_diagnosis");
var _get_preview_data = require("../../services/get_preview_data");
var _get_slo_instances = require("../../services/get_slo_instances");
var _historical_summary_client = require("../../services/historical_summary_client");
var _manage_slo = require("../../services/manage_slo");
var _reset_slo = require("../../services/reset_slo");
var _slo_definition_client = require("../../services/slo_definition_client");
var _slo_settings = require("../../services/slo_settings");
var _summary_search_client = require("../../services/summary_search_client");
var _summary_transform_generator = require("../../services/summary_transform_generator/summary_transform_generator");
var _transform_generators = require("../../services/transform_generators");
var _create_slo_server_route = require("../create_slo_server_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformGenerators = {
  'sli.apm.transactionDuration': new _transform_generators.ApmTransactionDurationTransformGenerator(),
  'sli.apm.transactionErrorRate': new _transform_generators.ApmTransactionErrorRateTransformGenerator(),
  'sli.synthetics.availability': new _transform_generators.SyntheticsAvailabilityTransformGenerator(),
  'sli.kql.custom': new _transform_generators.KQLCustomTransformGenerator(),
  'sli.metric.custom': new _transform_generators.MetricCustomTransformGenerator(),
  'sli.histogram.custom': new _transform_generators.HistogramTransformGenerator(),
  'sli.metric.timeslice': new _transform_generators.TimesliceMetricTransformGenerator()
};
const assertPlatinumLicense = async context => {
  const licensing = await context.licensing;
  const hasCorrectLicense = licensing.license.hasAtLeast('platinum');
  if (!hasCorrectLicense) {
    throw (0, _boom.forbidden)('Platinum license or higher is needed to make use of this feature.');
  }
};
const createSLORoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /api/observability/slos 2023-10-31',
  options: {
    tags: ['access:slo_write'],
    access: 'public'
  },
  params: _sloSchema.createSLOParamsSchema,
  handler: async ({
    context,
    params,
    logger,
    dependencies,
    request
  }) => {
    var _await$dependencies$s, _await$dependencies$s2, _dependencies$spaces, _dependencies$spaces$;
    await assertPlatinumLicense(context);
    const spaceId = (_await$dependencies$s = (_await$dependencies$s2 = await ((_dependencies$spaces = dependencies.spaces) === null || _dependencies$spaces === void 0 ? void 0 : (_dependencies$spaces$ = _dependencies$spaces.spacesService) === null || _dependencies$spaces$ === void 0 ? void 0 : _dependencies$spaces$.getActiveSpace(request))) === null || _await$dependencies$s2 === void 0 ? void 0 : _await$dependencies$s2.id) !== null && _await$dependencies$s !== void 0 ? _await$dependencies$s : 'default';
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const basePath = dependencies.pluginsSetup.core.http.basePath;
    const soClient = (await context.core).savedObjects.client;
    const repository = new _services.KibanaSavedObjectsSLORepository(soClient, logger);
    const transformManager = new _services.DefaultTransformManager(transformGenerators, esClient, logger, spaceId);
    const summaryTransformManager = new _services.DefaultSummaryTransformManager(new _summary_transform_generator.DefaultSummaryTransformGenerator(), esClient, logger);
    const createSLO = new _services.CreateSLO(esClient, repository, transformManager, summaryTransformManager, logger, spaceId, basePath);
    const response = await createSLO.execute(params.body);
    return response;
  }
});
const inspectSLORoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /internal/api/observability/slos/_inspect 2023-10-31',
  options: {
    tags: ['access:slo_write'],
    access: 'public'
  },
  params: _sloSchema.createSLOParamsSchema,
  handler: async ({
    context,
    params,
    logger,
    dependencies,
    request
  }) => {
    var _await$dependencies$s3, _await$dependencies$s4, _dependencies$spaces2, _dependencies$spaces3;
    await assertPlatinumLicense(context);
    const spaceId = (_await$dependencies$s3 = (_await$dependencies$s4 = await ((_dependencies$spaces2 = dependencies.spaces) === null || _dependencies$spaces2 === void 0 ? void 0 : (_dependencies$spaces3 = _dependencies$spaces2.spacesService) === null || _dependencies$spaces3 === void 0 ? void 0 : _dependencies$spaces3.getActiveSpace(request))) === null || _await$dependencies$s4 === void 0 ? void 0 : _await$dependencies$s4.id) !== null && _await$dependencies$s3 !== void 0 ? _await$dependencies$s3 : 'default';
    const basePath = dependencies.pluginsSetup.core.http.basePath;
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const soClient = (await context.core).savedObjects.client;
    const repository = new _services.KibanaSavedObjectsSLORepository(soClient, logger);
    const transformManager = new _services.DefaultTransformManager(transformGenerators, esClient, logger, spaceId);
    const summaryTransformManager = new _services.DefaultSummaryTransformManager(new _summary_transform_generator.DefaultSummaryTransformGenerator(), esClient, logger);
    const createSLO = new _services.CreateSLO(esClient, repository, transformManager, summaryTransformManager, logger, spaceId, basePath);
    return createSLO.inspect(params.body);
  }
});
const updateSLORoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'PUT /api/observability/slos/{id} 2023-10-31',
  options: {
    tags: ['access:slo_write'],
    access: 'public'
  },
  params: _sloSchema.updateSLOParamsSchema,
  handler: async ({
    context,
    request,
    params,
    logger,
    dependencies
  }) => {
    var _await$dependencies$s5, _await$dependencies$s6, _dependencies$spaces4, _dependencies$spaces5;
    await assertPlatinumLicense(context);
    const spaceId = (_await$dependencies$s5 = (_await$dependencies$s6 = await ((_dependencies$spaces4 = dependencies.spaces) === null || _dependencies$spaces4 === void 0 ? void 0 : (_dependencies$spaces5 = _dependencies$spaces4.spacesService) === null || _dependencies$spaces5 === void 0 ? void 0 : _dependencies$spaces5.getActiveSpace(request))) === null || _await$dependencies$s6 === void 0 ? void 0 : _await$dependencies$s6.id) !== null && _await$dependencies$s5 !== void 0 ? _await$dependencies$s5 : 'default';
    const basePath = dependencies.pluginsSetup.core.http.basePath;
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const soClient = (await context.core).savedObjects.client;
    const repository = new _services.KibanaSavedObjectsSLORepository(soClient, logger);
    const transformManager = new _services.DefaultTransformManager(transformGenerators, esClient, logger, spaceId);
    const summaryTransformManager = new _services.DefaultSummaryTransformManager(new _summary_transform_generator.DefaultSummaryTransformGenerator(), esClient, logger);
    const updateSLO = new _services.UpdateSLO(repository, transformManager, summaryTransformManager, esClient, logger, spaceId, basePath);
    const response = await updateSLO.execute(params.path.id, params.body);
    return response;
  }
});
const deleteSLORoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'DELETE /api/observability/slos/{id} 2023-10-31',
  options: {
    tags: ['access:slo_write'],
    access: 'public'
  },
  params: _sloSchema.deleteSLOParamsSchema,
  handler: async ({
    request,
    context,
    params,
    logger,
    dependencies
  }) => {
    var _await$dependencies$s7, _await$dependencies$s8, _dependencies$spaces6, _dependencies$spaces7;
    await assertPlatinumLicense(context);
    const spaceId = (_await$dependencies$s7 = (_await$dependencies$s8 = await ((_dependencies$spaces6 = dependencies.spaces) === null || _dependencies$spaces6 === void 0 ? void 0 : (_dependencies$spaces7 = _dependencies$spaces6.spacesService) === null || _dependencies$spaces7 === void 0 ? void 0 : _dependencies$spaces7.getActiveSpace(request))) === null || _await$dependencies$s8 === void 0 ? void 0 : _await$dependencies$s8.id) !== null && _await$dependencies$s7 !== void 0 ? _await$dependencies$s7 : 'default';
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const soClient = (await context.core).savedObjects.client;
    const rulesClient = dependencies.getRulesClientWithRequest(request);
    const repository = new _services.KibanaSavedObjectsSLORepository(soClient, logger);
    const transformManager = new _services.DefaultTransformManager(transformGenerators, esClient, logger, spaceId);
    const summaryTransformManager = new _services.DefaultSummaryTransformManager(new _summary_transform_generator.DefaultSummaryTransformGenerator(), esClient, logger);
    const deleteSLO = new _services.DeleteSLO(repository, transformManager, summaryTransformManager, esClient, rulesClient);
    await deleteSLO.execute(params.path.id);
  }
});
const getSLORoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'GET /api/observability/slos/{id} 2023-10-31',
  options: {
    tags: ['access:slo_read'],
    access: 'public'
  },
  params: _sloSchema.getSLOParamsSchema,
  handler: async ({
    request,
    context,
    params,
    logger,
    dependencies
  }) => {
    var _await$dependencies$s9, _await$dependencies$s10, _dependencies$spaces8, _dependencies$spaces9;
    await assertPlatinumLicense(context);
    const spaceId = (_await$dependencies$s9 = (_await$dependencies$s10 = await ((_dependencies$spaces8 = dependencies.spaces) === null || _dependencies$spaces8 === void 0 ? void 0 : (_dependencies$spaces9 = _dependencies$spaces8.spacesService) === null || _dependencies$spaces9 === void 0 ? void 0 : _dependencies$spaces9.getActiveSpace(request))) === null || _await$dependencies$s10 === void 0 ? void 0 : _await$dependencies$s10.id) !== null && _await$dependencies$s9 !== void 0 ? _await$dependencies$s9 : 'default';
    const soClient = (await context.core).savedObjects.client;
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const repository = new _services.KibanaSavedObjectsSLORepository(soClient, logger);
    const summaryClient = new _services.DefaultSummaryClient(esClient);
    const defintionClient = new _slo_definition_client.SloDefinitionClient(repository, esClient, logger);
    const getSLO = new _services.GetSLO(defintionClient, summaryClient);
    return await getSLO.execute(params.path.id, spaceId, params.query);
  }
});
const enableSLORoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /api/observability/slos/{id}/enable 2023-10-31',
  options: {
    tags: ['access:slo_write'],
    access: 'public'
  },
  params: _sloSchema.manageSLOParamsSchema,
  handler: async ({
    request,
    context,
    params,
    logger,
    dependencies
  }) => {
    var _await$dependencies$s11, _await$dependencies$s12, _dependencies$spaces10, _dependencies$spaces11;
    await assertPlatinumLicense(context);
    const spaceId = (_await$dependencies$s11 = (_await$dependencies$s12 = await ((_dependencies$spaces10 = dependencies.spaces) === null || _dependencies$spaces10 === void 0 ? void 0 : (_dependencies$spaces11 = _dependencies$spaces10.spacesService) === null || _dependencies$spaces11 === void 0 ? void 0 : _dependencies$spaces11.getActiveSpace(request))) === null || _await$dependencies$s12 === void 0 ? void 0 : _await$dependencies$s12.id) !== null && _await$dependencies$s11 !== void 0 ? _await$dependencies$s11 : 'default';
    const soClient = (await context.core).savedObjects.client;
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const repository = new _services.KibanaSavedObjectsSLORepository(soClient, logger);
    const transformManager = new _services.DefaultTransformManager(transformGenerators, esClient, logger, spaceId);
    const summaryTransformManager = new _services.DefaultSummaryTransformManager(new _summary_transform_generator.DefaultSummaryTransformGenerator(), esClient, logger);
    const manageSLO = new _manage_slo.ManageSLO(repository, transformManager, summaryTransformManager);
    const response = await manageSLO.enable(params.path.id);
    return response;
  }
});
const disableSLORoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /api/observability/slos/{id}/disable 2023-10-31',
  options: {
    tags: ['access:slo_write'],
    access: 'public'
  },
  params: _sloSchema.manageSLOParamsSchema,
  handler: async ({
    request,
    context,
    params,
    logger,
    dependencies
  }) => {
    var _await$dependencies$s13, _await$dependencies$s14, _dependencies$spaces12, _dependencies$spaces13;
    await assertPlatinumLicense(context);
    const spaceId = (_await$dependencies$s13 = (_await$dependencies$s14 = await ((_dependencies$spaces12 = dependencies.spaces) === null || _dependencies$spaces12 === void 0 ? void 0 : (_dependencies$spaces13 = _dependencies$spaces12.spacesService) === null || _dependencies$spaces13 === void 0 ? void 0 : _dependencies$spaces13.getActiveSpace(request))) === null || _await$dependencies$s14 === void 0 ? void 0 : _await$dependencies$s14.id) !== null && _await$dependencies$s13 !== void 0 ? _await$dependencies$s13 : 'default';
    const soClient = (await context.core).savedObjects.client;
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const repository = new _services.KibanaSavedObjectsSLORepository(soClient, logger);
    const transformManager = new _services.DefaultTransformManager(transformGenerators, esClient, logger, spaceId);
    const summaryTransformManager = new _services.DefaultSummaryTransformManager(new _summary_transform_generator.DefaultSummaryTransformGenerator(), esClient, logger);
    const manageSLO = new _manage_slo.ManageSLO(repository, transformManager, summaryTransformManager);
    const response = await manageSLO.disable(params.path.id);
    return response;
  }
});
const resetSLORoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /api/observability/slos/{id}/_reset 2023-10-31',
  options: {
    tags: ['access:slo_write'],
    access: 'public'
  },
  params: _sloSchema.resetSLOParamsSchema,
  handler: async ({
    context,
    request,
    params,
    logger,
    dependencies
  }) => {
    var _await$dependencies$s15, _await$dependencies$s16, _dependencies$spaces14, _dependencies$spaces15;
    await assertPlatinumLicense(context);
    const spaceId = (_await$dependencies$s15 = (_await$dependencies$s16 = await ((_dependencies$spaces14 = dependencies.spaces) === null || _dependencies$spaces14 === void 0 ? void 0 : (_dependencies$spaces15 = _dependencies$spaces14.spacesService) === null || _dependencies$spaces15 === void 0 ? void 0 : _dependencies$spaces15.getActiveSpace(request))) === null || _await$dependencies$s16 === void 0 ? void 0 : _await$dependencies$s16.id) !== null && _await$dependencies$s15 !== void 0 ? _await$dependencies$s15 : 'default';
    const soClient = (await context.core).savedObjects.client;
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const basePath = dependencies.pluginsSetup.core.http.basePath;
    const repository = new _services.KibanaSavedObjectsSLORepository(soClient, logger);
    const transformManager = new _services.DefaultTransformManager(transformGenerators, esClient, logger, spaceId);
    const summaryTransformManager = new _services.DefaultSummaryTransformManager(new _summary_transform_generator.DefaultSummaryTransformGenerator(), esClient, logger);
    const resetSLO = new _reset_slo.ResetSLO(esClient, repository, transformManager, summaryTransformManager, logger, spaceId, basePath);
    const response = await resetSLO.execute(params.path.id);
    return response;
  }
});
const findSLORoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'GET /api/observability/slos 2023-10-31',
  options: {
    tags: ['access:slo_read'],
    access: 'public'
  },
  params: _sloSchema.findSLOParamsSchema,
  handler: async ({
    context,
    request,
    params,
    logger,
    dependencies
  }) => {
    var _await$dependencies$s17, _await$dependencies$s18, _dependencies$spaces16, _dependencies$spaces17, _params$query;
    await assertPlatinumLicense(context);
    const spaceId = (_await$dependencies$s17 = (_await$dependencies$s18 = await ((_dependencies$spaces16 = dependencies.spaces) === null || _dependencies$spaces16 === void 0 ? void 0 : (_dependencies$spaces17 = _dependencies$spaces16.spacesService) === null || _dependencies$spaces17 === void 0 ? void 0 : _dependencies$spaces17.getActiveSpace(request))) === null || _await$dependencies$s18 === void 0 ? void 0 : _await$dependencies$s18.id) !== null && _await$dependencies$s17 !== void 0 ? _await$dependencies$s17 : 'default';
    const soClient = (await context.core).savedObjects.client;
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const repository = new _services.KibanaSavedObjectsSLORepository(soClient, logger);
    const summarySearchClient = new _summary_search_client.DefaultSummarySearchClient(esClient, soClient, logger, spaceId);
    const findSLO = new _services.FindSLO(repository, summarySearchClient);
    return await findSLO.execute((_params$query = params === null || params === void 0 ? void 0 : params.query) !== null && _params$query !== void 0 ? _params$query : {});
  }
});
const findSLOGroupsRoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'GET /internal/api/observability/slos/_groups',
  options: {
    tags: ['access:slo_read'],
    access: 'internal'
  },
  params: _sloSchema.findSLOGroupsParamsSchema,
  handler: async ({
    context,
    request,
    params,
    logger,
    dependencies
  }) => {
    var _await$dependencies$s19, _await$dependencies$s20, _dependencies$spaces18, _params$query2;
    await assertPlatinumLicense(context);
    const spaceId = (_await$dependencies$s19 = (_await$dependencies$s20 = await ((_dependencies$spaces18 = dependencies.spaces) === null || _dependencies$spaces18 === void 0 ? void 0 : _dependencies$spaces18.spacesService.getActiveSpace(request))) === null || _await$dependencies$s20 === void 0 ? void 0 : _await$dependencies$s20.id) !== null && _await$dependencies$s19 !== void 0 ? _await$dependencies$s19 : 'default';
    const soClient = (await context.core).savedObjects.client;
    const coreContext = context.core;
    const esClient = (await coreContext).elasticsearch.client.asCurrentUser;
    const findSLOGroups = new _services.FindSLOGroups(esClient, soClient, logger, spaceId);
    const response = await findSLOGroups.execute((_params$query2 = params === null || params === void 0 ? void 0 : params.query) !== null && _params$query2 !== void 0 ? _params$query2 : {});
    return response;
  }
});
const deleteSloInstancesRoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /api/observability/slos/_delete_instances 2023-10-31',
  options: {
    tags: ['access:slo_write']
  },
  params: _sloSchema.deleteSLOInstancesParamsSchema,
  handler: async ({
    context,
    params
  }) => {
    await assertPlatinumLicense(context);
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const deleteSloInstances = new _services.DeleteSLOInstances(esClient);
    await deleteSloInstances.execute(params.body);
  }
});
const findSloDefinitionsRoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'GET /api/observability/slos/_definitions 2023-10-31',
  options: {
    tags: ['access:slo_read']
  },
  params: _sloSchema.findSloDefinitionsParamsSchema,
  handler: async ({
    context,
    params,
    logger
  }) => {
    var _params$query3;
    await assertPlatinumLicense(context);
    const soClient = (await context.core).savedObjects.client;
    const repository = new _services.KibanaSavedObjectsSLORepository(soClient, logger);
    const findSloDefinitions = new _find_slo_definitions.FindSLODefinitions(repository);
    const response = await findSloDefinitions.execute((_params$query3 = params === null || params === void 0 ? void 0 : params.query) !== null && _params$query3 !== void 0 ? _params$query3 : {});
    return response;
  }
});
const fetchHistoricalSummary = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /internal/observability/slos/_historical_summary',
  options: {
    tags: ['access:slo_read']
  },
  params: _sloSchema.fetchHistoricalSummaryParamsSchema,
  handler: async ({
    context,
    params,
    logger
  }) => {
    await assertPlatinumLicense(context);
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const historicalSummaryClient = new _historical_summary_client.DefaultHistoricalSummaryClient(esClient);
    const fetchSummaryData = new _fetch_historical_summary.FetchHistoricalSummary(historicalSummaryClient);
    return await fetchSummaryData.execute(params.body);
  }
});
const getSLOInstancesRoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'GET /internal/observability/slos/{id}/_instances',
  options: {
    tags: ['access:slo_read'],
    access: 'internal'
  },
  params: _sloSchema.getSLOInstancesParamsSchema,
  handler: async ({
    context,
    params,
    logger
  }) => {
    await assertPlatinumLicense(context);
    const soClient = (await context.core).savedObjects.client;
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const repository = new _services.KibanaSavedObjectsSLORepository(soClient, logger);
    const getSLOInstances = new _get_slo_instances.GetSLOInstances(repository, esClient);
    const response = await getSLOInstances.execute(params.path.id);
    return response;
  }
});
const getDiagnosisRoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'GET /internal/observability/slos/_diagnosis',
  options: {
    tags: [],
    access: 'internal'
  },
  params: undefined,
  handler: async ({
    context
  }) => {
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const licensing = await context.licensing;
    try {
      const response = await (0, _get_diagnosis.getGlobalDiagnosis)(esClient, licensing);
      return response;
    } catch (error) {
      if (error instanceof _elasticsearch.errors.ResponseError && error.statusCode === 403) {
        throw (0, _boom.forbidden)('Insufficient Elasticsearch cluster permissions to access feature.');
      }
      throw (0, _boom.failedDependency)(error);
    }
  }
});
const getSloBurnRates = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /internal/observability/slos/{id}/_burn_rates',
  options: {
    tags: ['access:slo_read'],
    access: 'internal'
  },
  params: _sloSchema.getSLOBurnRatesParamsSchema,
  handler: async ({
    request,
    context,
    params,
    logger,
    dependencies
  }) => {
    var _await$dependencies$s21, _await$dependencies$s22, _dependencies$spaces19;
    await assertPlatinumLicense(context);
    const spaceId = (_await$dependencies$s21 = (_await$dependencies$s22 = await ((_dependencies$spaces19 = dependencies.spaces) === null || _dependencies$spaces19 === void 0 ? void 0 : _dependencies$spaces19.spacesService.getActiveSpace(request))) === null || _await$dependencies$s22 === void 0 ? void 0 : _await$dependencies$s22.id) !== null && _await$dependencies$s21 !== void 0 ? _await$dependencies$s21 : 'default';
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const soClient = (await context.core).savedObjects.client;
    const {
      instanceId,
      windows,
      remoteName
    } = params.body;
    return await (0, _get_burn_rates.getBurnRates)({
      instanceId,
      spaceId,
      windows,
      remoteName,
      sloId: params.path.id,
      services: {
        soClient,
        esClient,
        logger
      }
    });
  }
});
const getPreviewData = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /internal/observability/slos/_preview',
  options: {
    tags: ['access:slo_read'],
    access: 'internal'
  },
  params: _sloSchema.getPreviewDataParamsSchema,
  handler: async ({
    request,
    context,
    params,
    dependencies
  }) => {
    var _await$dependencies$s23, _await$dependencies$s24, _dependencies$spaces20, _dependencies$spaces21;
    await assertPlatinumLicense(context);
    const spaceId = (_await$dependencies$s23 = (_await$dependencies$s24 = await ((_dependencies$spaces20 = dependencies.spaces) === null || _dependencies$spaces20 === void 0 ? void 0 : (_dependencies$spaces21 = _dependencies$spaces20.spacesService) === null || _dependencies$spaces21 === void 0 ? void 0 : _dependencies$spaces21.getActiveSpace(request))) === null || _await$dependencies$s24 === void 0 ? void 0 : _await$dependencies$s24.id) !== null && _await$dependencies$s23 !== void 0 ? _await$dependencies$s23 : 'default';
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const service = new _get_preview_data.GetPreviewData(esClient, spaceId);
    return await service.execute(params.body);
  }
});
const getSloSettingsRoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'GET /internal/slo/settings',
  options: {
    tags: ['access:slo_read'],
    access: 'internal'
  },
  handler: async ({
    context
  }) => {
    await assertPlatinumLicense(context);
    const soClient = (await context.core).savedObjects.client;
    return await (0, _slo_settings.getSloSettings)(soClient);
  }
});
const putSloSettings = isServerless => (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'PUT /internal/slo/settings',
  options: {
    tags: ['access:slo_write'],
    access: 'internal'
  },
  params: isServerless ? _sloSchema.putSLOServerlessSettingsParamsSchema : _sloSchema.putSLOSettingsParamsSchema,
  handler: async ({
    context,
    params
  }) => {
    await assertPlatinumLicense(context);
    const soClient = (await context.core).savedObjects.client;
    return await (0, _slo_settings.storeSloSettings)(soClient, params.body);
  }
});
const getSloRouteRepository = isServerless => {
  return {
    ...getSloSettingsRoute,
    ...putSloSettings(isServerless),
    ...createSLORoute,
    ...inspectSLORoute,
    ...deleteSLORoute,
    ...deleteSloInstancesRoute,
    ...disableSLORoute,
    ...enableSLORoute,
    ...fetchHistoricalSummary,
    ...findSloDefinitionsRoute,
    ...findSLORoute,
    ...getSLORoute,
    ...updateSLORoute,
    ...getDiagnosisRoute,
    ...getSloBurnRates,
    ...getPreviewData,
    ...getSLOInstancesRoute,
    ...resetSLORoute,
    ...findSLOGroupsRoute
  };
};
exports.getSloRouteRepository = getSloRouteRepository;