"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _common = require("@kbn/observability-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _register = require("./lib/collectors/register");
var _orphan_summary_cleanup_task = require("./services/tasks/orphan_summary_cleanup_task");
var _saved_objects = require("./saved_objects");
var _services = require("./services");
var _register_burn_rate_rule = require("./lib/rules/register_burn_rate_rule");
var _register_routes = require("./routes/register_routes");
var _get_slo_server_route_repository = require("./routes/get_slo_server_route_repository");
var _slo_settings = require("./saved_objects/slo_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sloRuleTypes = [_ruleDataUtils.SLO_BURN_RATE_RULE_TYPE_ID];
class SloPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "sloOrphanCleanupTask", void 0);
    this.initContext = initContext;
    this.initContext = initContext;
    this.logger = initContext.logger.get();
  }
  setup(core, plugins) {
    const config = this.initContext.config.get();
    const alertsLocator = plugins.share.url.locators.create(new _common.AlertsLocatorDefinition());
    const savedObjectTypes = [_saved_objects.SO_SLO_TYPE, _slo_settings.SO_SLO_SETTINGS_TYPE];
    plugins.features.registerKibanaFeature({
      id: _common.sloFeatureId,
      name: _i18n.i18n.translate('xpack.slo.featureRegistry.linkSloTitle', {
        defaultMessage: 'SLOs'
      }),
      order: 1200,
      category: _server.DEFAULT_APP_CATEGORIES.observability,
      app: [_common.sloFeatureId, 'kibana'],
      catalogue: [_common.sloFeatureId, 'observability'],
      alerting: sloRuleTypes,
      privileges: {
        all: {
          app: [_common.sloFeatureId, 'kibana'],
          catalogue: [_common.sloFeatureId, 'observability'],
          api: ['slo_write', 'slo_read', 'rac'],
          savedObject: {
            all: savedObjectTypes,
            read: []
          },
          alerting: {
            rule: {
              all: sloRuleTypes
            },
            alert: {
              all: sloRuleTypes
            }
          },
          ui: ['read', 'write']
        },
        read: {
          app: [_common.sloFeatureId, 'kibana'],
          catalogue: [_common.sloFeatureId, 'observability'],
          api: ['slo_read', 'rac'],
          savedObject: {
            all: [],
            read: savedObjectTypes
          },
          alerting: {
            rule: {
              read: sloRuleTypes
            },
            alert: {
              read: sloRuleTypes
            }
          },
          ui: ['read']
        }
      }
    });
    const {
      ruleDataService
    } = plugins.ruleRegistry;
    core.savedObjects.registerType(_saved_objects.slo);
    core.savedObjects.registerType(_slo_settings.sloSettings);
    (0, _register_burn_rate_rule.registerBurnRateRule)(plugins.alerting, core.http.basePath, this.logger, ruleDataService, {
      alertsLocator
    });
    (0, _register.registerSloUsageCollector)(plugins.usageCollection);
    core.getStartServices().then(([coreStart, pluginStart]) => {
      (0, _register_routes.registerRoutes)({
        core,
        config,
        dependencies: {
          pluginsSetup: {
            ...plugins,
            core
          },
          spaces: pluginStart.spaces,
          ruleDataService,
          getRulesClientWithRequest: pluginStart.alerting.getRulesClientWithRequest
        },
        logger: this.logger,
        repository: (0, _get_slo_server_route_repository.getSloServerRouteRepository)({
          isServerless: !!pluginStart.serverless
        })
      });
      const esInternalClient = coreStart.elasticsearch.client.asInternalUser;
      const sloResourceInstaller = new _services.DefaultResourceInstaller(esInternalClient, this.logger);
      const sloInstaller = new _services.DefaultSLOInstaller(sloResourceInstaller, this.logger);
      sloInstaller.install();
    });
    this.sloOrphanCleanupTask = new _orphan_summary_cleanup_task.SloOrphanSummaryCleanupTask(plugins.taskManager, this.logger, config);
  }
  start(core, plugins) {
    var _this$sloOrphanCleanu;
    const internalSoClient = new _server.SavedObjectsClient(core.savedObjects.createInternalRepository());
    const internalEsClient = core.elasticsearch.client.asInternalUser;
    (_this$sloOrphanCleanu = this.sloOrphanCleanupTask) === null || _this$sloOrphanCleanu === void 0 ? void 0 : _this$sloOrphanCleanu.start(plugins.taskManager, internalSoClient, internalEsClient);
  }
  stop() {}
}
exports.SloPlugin = SloPlugin;