"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSloAlertsUiActions = registerSloAlertsUiActions;
var _public = require("@kbn/embeddable-plugin/public");
var _edit_slo_alerts_panel = require("./edit_slo_alerts_panel");
var _edit_slo_overview_panel = require("./edit_slo_overview_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerSloAlertsUiActions(uiActions, core) {
  // Initialize actions
  const editSloAlertsPanelAction = (0, _edit_slo_alerts_panel.createEditSloAlertsPanelAction)(core.getStartServices);
  const editSloOverviewPanelAction = (0, _edit_slo_overview_panel.createEditSloOverviewPanelAction)(core.getStartServices);
  // Assign triggers
  uiActions.addTriggerAction(_public.CONTEXT_MENU_TRIGGER, editSloAlertsPanelAction);
  uiActions.addTriggerAction(_public.CONTEXT_MENU_TRIGGER, editSloOverviewPanelAction);
}