"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLO_PAGE_ID = void 0;
exports.SlosPage = SlosPage;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _header_menu = require("../../components/header_menu/header_menu");
var _kibana_react = require("../../utils/kibana_react");
var _feedback_button = require("./components/common/feedback_button");
var _create_slo_btn = require("./components/common/create_slo_btn");
var _slo_list_search_bar = require("./components/slo_list_search_bar");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_license = require("../../hooks/use_license");
var _use_fetch_slo_list = require("../../hooks/use_fetch_slo_list");
var _slo_list = require("./components/slo_list");
var _paths = require("../../../common/locators/paths");
var _slo_outdated_callout = require("../../components/slo/slo_outdated_callout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLO_PAGE_ID = exports.SLO_PAGE_ID = 'slo-page-container';
function SlosPage() {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    hasAtLeast
  } = (0, _use_license.useLicense)();
  const {
    isLoading,
    isError,
    data: sloList
  } = (0, _use_fetch_slo_list.useFetchSloList)({
    perPage: 0
  });
  const {
    total
  } = sloList !== null && sloList !== void 0 ? sloList : {
    total: 0
  };
  (0, _public.useBreadcrumbs)([{
    href: basePath.prepend(_paths.paths.slos),
    text: _i18n.i18n.translate('xpack.slo.breadcrumbs.slosLinkText', {
      defaultMessage: 'SLOs'
    }),
    deepLinkId: 'slo'
  }]);
  (0, _react.useEffect)(() => {
    if (!isLoading && total === 0 || hasAtLeast('platinum') === false || isError) {
      navigateToUrl(basePath.prepend(_paths.paths.slosWelcome));
    }
  }, [basePath, hasAtLeast, isError, isLoading, navigateToUrl, total]);
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "slosPage",
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.slo.slosPage.', {
        defaultMessage: 'SLOs'
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_create_slo_btn.CreateSloBtn, null), /*#__PURE__*/_react.default.createElement(_feedback_button.FeedbackButton, null)]
    },
    topSearchBar: /*#__PURE__*/_react.default.createElement(_slo_list_search_bar.SloListSearchBar, null)
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, null), /*#__PURE__*/_react.default.createElement(_slo_outdated_callout.SloOutdatedCallout, null), /*#__PURE__*/_react.default.createElement(_slo_list.SloList, null));
}