"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSloListActions = useSloListActions;
var _react = require("react");
var _kibana_react = require("../../../utils/kibana_react");
var _use_delete_slo = require("../../../hooks/use_delete_slo");
var _slo_embeddable = require("../../../embeddable/slo/overview/slo_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSloListActions({
  slo,
  setIsAddRuleFlyoutOpen,
  setIsActionsPopoverOpen,
  setDeleteConfirmationModalOpen
}) {
  var _slo$remote2;
  const {
    embeddable
  } = (0, _kibana_react.useKibana)().services;
  const {
    mutate: deleteSlo
  } = (0, _use_delete_slo.useDeleteSlo)();
  const handleDeleteConfirm = () => {
    setDeleteConfirmationModalOpen(false);
    deleteSlo({
      id: slo.id,
      name: slo.name
    });
  };
  const handleDeleteCancel = () => {
    setDeleteConfirmationModalOpen(false);
  };
  const handleCreateRule = () => {
    setIsActionsPopoverOpen(false);
    setIsAddRuleFlyoutOpen(true);
  };
  const handleAttachToDashboardSave = (0, _react.useCallback)(({
    dashboardId,
    newTitle,
    newDescription
  }) => {
    var _slo$remote;
    const stateTransfer = embeddable.getStateTransfer();
    const embeddableInput = {
      title: newTitle,
      description: newDescription,
      sloId: slo.id,
      sloInstanceId: slo.instanceId,
      remoteName: (_slo$remote = slo.remote) === null || _slo$remote === void 0 ? void 0 : _slo$remote.remoteName
    };
    const state = {
      input: embeddableInput,
      type: _slo_embeddable.SLO_EMBEDDABLE
    };
    const path = dashboardId === 'new' ? '#/create' : `#/view/${dashboardId}`;
    stateTransfer.navigateToWithEmbeddablePackage('dashboards', {
      state,
      path
    });
  }, [embeddable, slo.id, slo.instanceId, (_slo$remote2 = slo.remote) === null || _slo$remote2 === void 0 ? void 0 : _slo$remote2.remoteName]);
  return {
    handleDeleteConfirm,
    handleDeleteCancel,
    handleCreateRule,
    handleAttachToDashboardSave
  };
}