"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SlosView = SlosView;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _slos_card_view = require("./card_view/slos_card_view");
var _slo_list_compact_view = require("./compact_view/slo_list_compact_view");
var _slo_list_empty = require("./slo_list_empty");
var _slo_list_error = require("./slo_list_error");
var _slo_list_view = require("./slo_list_view/slo_list_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SlosView({
  sloList,
  loading,
  error,
  sloView
}) {
  if (!loading && !error && sloList.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_slo_list_empty.SloListEmpty, null);
  }
  if (!loading && error) {
    return /*#__PURE__*/_react.default.createElement(_slo_list_error.SloListError, null);
  }
  if (sloView === 'cardView') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_slos_card_view.SloListCardView, {
      sloList: sloList,
      loading: loading,
      error: error
    }));
  }
  if (sloView === 'compactView') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_slo_list_compact_view.SloListCompactView, {
      sloList: sloList,
      loading: loading,
      error: error
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_slo_list_view.SloListView, {
    sloList: sloList,
    loading: loading,
    error: error
  }));
}