"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloList = SloList;
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _react = _interopRequireWildcard(require("react"));
var _dedent = _interopRequireDefault(require("dedent"));
var _lodash = require("lodash");
var _kibana_react = require("../../../utils/kibana_react");
var _use_fetch_slo_list = require("../../../hooks/use_fetch_slo_list");
var _use_url_search_state = require("../hooks/use_url_search_state");
var _slos_view = require("./slos_view");
var _toggle_slo_view = require("./toggle_slo_view");
var _group_view = require("./grouped_slos/group_view");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloList() {
  const {
    state,
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  const {
    view,
    page,
    perPage,
    kqlQuery,
    filters,
    tagsFilter,
    statusFilter,
    groupBy
  } = state;
  const {
    isLoading,
    isRefetching,
    isError,
    data: sloList
  } = (0, _use_fetch_slo_list.useFetchSloList)({
    tagsFilter,
    statusFilter,
    perPage,
    filters,
    page: page + 1,
    kqlQuery,
    sortBy: state.sort.by,
    sortDirection: state.sort.direction,
    lastRefresh: state.lastRefresh
  });
  const {
    observabilityAIAssistant
  } = (0, _kibana_react.useKibana)().services;
  const {
    results = [],
    total = 0
  } = sloList !== null && sloList !== void 0 ? sloList : {};
  const isDeletingSlo = Boolean((0, _reactQuery.useIsMutating)(['deleteSlo']));
  (0, _react.useEffect)(() => {
    if (!sloList || !observabilityAIAssistant) {
      return;
    }
    const slosByStatus = (0, _lodash.mapValues)((0, _lodash.groupBy)(sloList.results, result => result.summary.status), groupResults => groupResults.map(result => `- ${result.name}`).join('\n'));
    return observabilityAIAssistant.service.setScreenContext({
      screenDescription: (0, _dedent.default)(`The user is looking at a list of SLOs.

      ${sloList.total >= 1 ? `There are ${sloList.total} SLOs. Out of those, ${sloList.results.length} are visible.

          Violating SLOs:
          ${slosByStatus.VIOLATED}

          Degrading SLOs:
          ${slosByStatus.DEGRADING}

          Healthy SLOs:
          ${slosByStatus.HEALTHY}

          SLOs without data:
          ${slosByStatus.NO_DATA}

          ` : ''}
      `)
    });
  }, [sloList, observabilityAIAssistant]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "sloList"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_toggle_slo_view.ToggleSLOView, {
    sloList: sloList,
    sloView: view,
    onChangeView: newView => onStateChange({
      view: newView
    }),
    onStateChange: onStateChange,
    state: state,
    loading: isLoading || isDeletingSlo
  })), groupBy === 'ungrouped' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_slos_view.SlosView, {
    sloList: results,
    loading: isLoading || isRefetching,
    error: isError,
    sloView: view
  }), total > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    pageCount: Math.ceil(total / perPage),
    activePage: page,
    onChangePage: newPage => {
      onStateChange({
        page: newPage
      });
    },
    itemsPerPage: perPage,
    itemsPerPageOptions: [10, 25, 50, 100],
    onChangeItemsPerPage: newPerPage => {
      onStateChange({
        perPage: newPerPage
      });
    }
  })) : null), groupBy !== 'ungrouped' && /*#__PURE__*/_react.default.createElement(_group_view.GroupView, {
    sloView: view,
    groupBy: groupBy,
    kqlQuery: kqlQuery,
    sort: state.sort.by,
    direction: state.sort.direction,
    filters: filters
  }));
}