"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloItemActions = SloItemActions;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_capabilities = require("../../../hooks/use_capabilities");
var _use_clone_slo = require("../../../hooks/use_clone_slo");
var _kibana_react = require("../../../utils/kibana_react");
var _use_slo_actions = require("../../slo_details/hooks/use_slo_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomShadowPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  ${props => props.shadow}
`;
function IconPanel({
  children,
  hasPanel
}) {
  const shadow = (0, _eui.useEuiShadow)('s');
  if (!hasPanel) return children;
  return /*#__PURE__*/_react.default.createElement(CustomShadowPanel, {
    color: "plain",
    element: "button",
    grow: false,
    paddingSize: "none",
    hasShadow: false,
    shadow: shadow
  }, children);
}
function SloItemActions({
  slo,
  rules,
  isActionsPopoverOpen,
  setIsActionsPopoverOpen,
  setIsAddRuleFlyoutOpen,
  setIsEditRuleFlyoutOpen,
  setDeleteConfirmationModalOpen,
  setDashboardAttachmentReady,
  btnProps
}) {
  var _rules$length;
  const {
    application: {
      navigateToUrl
    },
    executionContext
  } = (0, _kibana_react.useKibana)().services;
  const executionContextName = executionContext.get().name;
  const isDashboardContext = executionContextName === 'dashboards';
  const {
    hasWriteCapabilities
  } = (0, _use_capabilities.useCapabilities)();
  const navigateToClone = (0, _use_clone_slo.useCloneSlo)();
  const {
    handleNavigateToRules,
    sloEditUrl,
    remoteDeleteUrl,
    sloDetailsUrl
  } = (0, _use_slo_actions.useSloActions)({
    slo,
    rules,
    setIsEditRuleFlyoutOpen,
    setIsActionsPopoverOpen
  });
  const handleClickActions = () => {
    setIsActionsPopoverOpen(!isActionsPopoverOpen);
  };
  const handleViewDetails = () => {
    navigateToUrl(sloDetailsUrl);
  };
  const handleClone = () => {
    navigateToClone(slo);
  };
  const handleDelete = () => {
    if (!!remoteDeleteUrl) {
      window.open(remoteDeleteUrl, '_blank');
    } else {
      setDeleteConfirmationModalOpen(true);
      setIsActionsPopoverOpen(false);
    }
  };
  const handleCreateRule = () => {
    setIsActionsPopoverOpen(false);
    setIsAddRuleFlyoutOpen(true);
  };
  const handleAddToDashboard = () => {
    setIsActionsPopoverOpen(false);
    if (setDashboardAttachmentReady) {
      setDashboardAttachmentReady(true);
    }
  };
  const btn = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "o11ySloListItemButton",
    "aria-label": _i18n.i18n.translate('xpack.slo.item.actions.button', {
      defaultMessage: 'Actions'
    }),
    color: "text",
    disabled: !slo.summary,
    display: "empty",
    iconType: "boxesVertical",
    size: "s",
    onClick: handleClickActions
  }, btnProps));
  const isRemote = !!slo.remote;
  const hasUndefinedRemoteKibanaUrl = !!slo.remote && slo.remote.kibanaUrl === '';
  const showRemoteLinkIcon = isRemote ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout",
    size: "s",
    css: {
      marginLeft: '10px'
    }
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: btnProps ? /*#__PURE__*/_react.default.createElement(IconPanel, {
      hasPanel: true
    }, btn) : btn,
    panelPaddingSize: "m",
    closePopover: handleClickActions,
    isOpen: isActionsPopoverOpen
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "m",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "view",
      icon: "inspect",
      onClick: handleViewDetails,
      "data-test-subj": "sloActionsView"
    }, _i18n.i18n.translate('xpack.slo.item.actions.details', {
      defaultMessage: 'Details'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "edit",
      icon: "pencil",
      disabled: !hasWriteCapabilities || hasUndefinedRemoteKibanaUrl,
      href: sloEditUrl,
      target: isRemote ? '_blank' : undefined,
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      "data-test-subj": "sloActionsEdit"
    }, _i18n.i18n.translate('xpack.slo.item.actions.edit', {
      defaultMessage: 'Edit'
    }), showRemoteLinkIcon), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "createRule",
      icon: "bell",
      disabled: !hasWriteCapabilities || isRemote,
      onClick: handleCreateRule,
      "data-test-subj": "sloActionsCreateRule",
      toolTipContent: isRemote ? NOT_AVAILABLE_FOR_REMOTE : ''
    }, _i18n.i18n.translate('xpack.slo.item.actions.createRule', {
      defaultMessage: 'Create new alert rule'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "manageRules",
      icon: "gear",
      disabled: !hasWriteCapabilities || hasUndefinedRemoteKibanaUrl,
      onClick: handleNavigateToRules,
      "data-test-subj": "sloActionsManageRules",
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : ''
    }, _i18n.i18n.translate('xpack.slo.item.actions.manageBurnRateRules', {
      defaultMessage: 'Manage burn rate {count, plural, one {rule} other {rules}}',
      values: {
        count: (_rules$length = rules === null || rules === void 0 ? void 0 : rules.length) !== null && _rules$length !== void 0 ? _rules$length : 0
      }
    }), showRemoteLinkIcon), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "clone",
      disabled: !hasWriteCapabilities || hasUndefinedRemoteKibanaUrl,
      icon: "copy",
      onClick: handleClone,
      "data-test-subj": "sloActionsClone",
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : ''
    }, _i18n.i18n.translate('xpack.slo.item.actions.clone', {
      defaultMessage: 'Clone'
    }), showRemoteLinkIcon), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "delete",
      icon: "trash",
      disabled: !hasWriteCapabilities || hasUndefinedRemoteKibanaUrl,
      onClick: handleDelete,
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      "data-test-subj": "sloActionsDelete"
    }, _i18n.i18n.translate('xpack.slo.item.actions.delete', {
      defaultMessage: 'Delete'
    }), showRemoteLinkIcon)].concat(!isDashboardContext ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "dashboardApp",
      key: "addToDashboard",
      onClick: handleAddToDashboard,
      "data-test-subj": "sloActionsAddToDashboard"
    }, _i18n.i18n.translate('xpack.slo.item.actions.addToDashboard', {
      defaultMessage: 'Add to Dashboard'
    })) : [])
  }));
}
const NOT_AVAILABLE_FOR_REMOTE = _i18n.i18n.translate('xpack.slo.item.actions.notAvailable', {
  defaultMessage: 'This action is not available for remote SLOs'
});
const NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL = _i18n.i18n.translate('xpack.slo.item.actions.remoteKibanaUrlUndefined', {
  defaultMessage: 'This action is not available for remote SLOs with undefined kibanaUrl'
});