"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloListCompactView = SloListCompactView;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _sloSchema = require("@kbn/slo-schema");
var _reactQuery = require("@tanstack/react-query");
var _react = _interopRequireWildcard(require("react"));
var _i18n2 = require("../../../../../common/i18n");
var _paths = require("../../../../../common/locators/paths");
var _slo_delete_confirmation_modal = require("../../../../components/slo/delete_confirmation_modal/slo_delete_confirmation_modal");
var _slo_status_badge = require("../../../../components/slo/slo_status_badge");
var _slo_active_alerts_badge = require("../../../../components/slo/slo_status_badge/slo_active_alerts_badge");
var _query_key_factory = require("../../../../hooks/query_key_factory");
var _use_capabilities = require("../../../../hooks/use_capabilities");
var _use_clone_slo = require("../../../../hooks/use_clone_slo");
var _use_delete_slo = require("../../../../hooks/use_delete_slo");
var _use_fetch_active_alerts = require("../../../../hooks/use_fetch_active_alerts");
var _use_fetch_historical_summary = require("../../../../hooks/use_fetch_historical_summary");
var _use_fetch_rules_for_slo = require("../../../../hooks/use_fetch_rules_for_slo");
var _use_get_filtered_rule_types = require("../../../../hooks/use_get_filtered_rule_types");
var _use_space = require("../../../../hooks/use_space");
var _kibana_react = require("../../../../utils/kibana_react");
var _chart_data_formatter = require("../../../../utils/slo/chart_data_formatter");
var _remote_slo_urls = require("../../../../utils/slo/remote_slo_urls");
var _slo_remote_badge = require("../badges/slo_remote_badge");
var _slo_rules_badge = require("../badges/slo_rules_badge");
var _slo_groupings = require("../common/slo_groupings");
var _slo_tags_list = require("../common/slo_tags_list");
var _slo_list_empty = require("../slo_list_empty");
var _slo_list_error = require("../slo_list_error");
var _slo_sparkline = require("../slo_sparkline");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloListCompactView({
  sloList,
  loading,
  error
}) {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    },
    uiSettings,
    share: {
      url: {
        locators
      }
    },
    triggersActionsUi: {
      getAddRuleFlyout: AddRuleFlyout
    }
  } = (0, _kibana_react.useKibana)().services;
  const spaceId = (0, _use_space.useSpace)();
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  const sloIdsAndInstanceIds = sloList.map(slo => {
    var _slo$instanceId;
    return [slo.id, (_slo$instanceId = slo.instanceId) !== null && _slo$instanceId !== void 0 ? _slo$instanceId : _sloSchema.ALL_VALUE];
  });
  const {
    hasWriteCapabilities
  } = (0, _use_capabilities.useCapabilities)();
  const filteredRuleTypes = (0, _use_get_filtered_rule_types.useGetFilteredRuleTypes)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    mutate: deleteSlo
  } = (0, _use_delete_slo.useDeleteSlo)();
  const [sloToAddRule, setSloToAddRule] = (0, _react.useState)(undefined);
  const [sloToDelete, setSloToDelete] = (0, _react.useState)(undefined);
  const handleDeleteConfirm = () => {
    if (sloToDelete) {
      deleteSlo({
        id: sloToDelete.id,
        name: sloToDelete.name
      });
    }
    setSloToDelete(undefined);
  };
  const handleDeleteCancel = () => {
    setSloToDelete(undefined);
  };
  const handleSavedRule = async () => {
    queryClient.invalidateQueries({
      queryKey: _query_key_factory.sloKeys.rules(),
      exact: false
    });
  };
  const {
    data: activeAlertsBySlo
  } = (0, _use_fetch_active_alerts.useFetchActiveAlerts)({
    sloIdsAndInstanceIds
  });
  const {
    data: rulesBySlo
  } = (0, _use_fetch_rules_for_slo.useFetchRulesForSlo)({
    sloIds: sloIdsAndInstanceIds.map(item => item[0])
  });
  const {
    isLoading: historicalSummaryLoading,
    data: historicalSummaries = []
  } = (0, _use_fetch_historical_summary.useFetchHistoricalSummary)({
    sloList
  });
  const navigateToClone = (0, _use_clone_slo.useCloneSlo)();
  const isRemote = slo => !!slo.remote;
  const hasRemoteKibanaUrl = slo => !!slo.remote && slo.remote.kibanaUrl !== '';
  const buildActionName = actionName => slo => isRemote(slo) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, actionName, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout",
    size: "s",
    css: {
      marginLeft: '10px'
    }
  })) : actionName;
  const actions = [{
    type: 'icon',
    icon: 'inspect',
    name: _i18n.i18n.translate('xpack.slo.item.actions.details', {
      defaultMessage: 'Details'
    }),
    description: _i18n.i18n.translate('xpack.slo.item.actions.details', {
      defaultMessage: 'Details'
    }),
    onClick: slo => {
      var _slo$remote;
      const sloDetailsUrl = basePath.prepend(_paths.paths.sloDetails(slo.id, ![slo.groupBy].flat().includes(_sloSchema.ALL_VALUE) && slo.instanceId ? slo.instanceId : undefined, (_slo$remote = slo.remote) === null || _slo$remote === void 0 ? void 0 : _slo$remote.remoteName));
      navigateToUrl(sloDetailsUrl);
    }
  }, {
    type: 'icon',
    icon: 'pencil',
    name: buildActionName(_i18n.i18n.translate('xpack.slo.item.actions.edit', {
      defaultMessage: 'Edit'
    })),
    description: _i18n.i18n.translate('xpack.slo.item.actions.edit', {
      defaultMessage: 'Edit'
    }),
    'data-test-subj': 'sloActionsEdit',
    enabled: slo => hasWriteCapabilities && !isRemote(slo) || hasRemoteKibanaUrl(slo),
    onClick: slo => {
      const remoteEditUrl = (0, _remote_slo_urls.createRemoteSloEditUrl)(slo, spaceId);
      if (!!remoteEditUrl) {
        window.open(remoteEditUrl, '_blank');
      } else {
        navigateToUrl(basePath.prepend(_paths.paths.sloEdit(slo.id)));
      }
    }
  }, {
    type: 'icon',
    icon: 'bell',
    name: _i18n.i18n.translate('xpack.slo.item.actions.createRule', {
      defaultMessage: 'Create new alert rule'
    }),
    description: _i18n.i18n.translate('xpack.slo.item.actions.createRule', {
      defaultMessage: 'Create new alert rule'
    }),
    'data-test-subj': 'sloActionsCreateRule',
    enabled: slo => hasWriteCapabilities && !isRemote(slo),
    onClick: slo => {
      setSloToAddRule(slo);
    }
  }, {
    type: 'icon',
    icon: 'gear',
    name: _i18n.i18n.translate('xpack.slo.item.actions.manageRules', {
      defaultMessage: 'Manage rules'
    }),
    description: _i18n.i18n.translate('xpack.slo.item.actions.manageRules', {
      defaultMessage: 'Manage rules'
    }),
    'data-test-subj': 'sloActionsManageRules',
    enabled: slo => hasWriteCapabilities && !isRemote(slo),
    onClick: slo => {
      const locator = locators.get(_common.rulesLocatorID);
      locator === null || locator === void 0 ? void 0 : locator.navigate({
        params: {
          sloId: slo.id
        }
      }, {
        replace: false
      });
    }
  }, {
    type: 'icon',
    icon: 'copy',
    name: buildActionName(_i18n.i18n.translate('xpack.slo.item.actions.clone', {
      defaultMessage: 'Clone'
    })),
    description: _i18n.i18n.translate('xpack.slo.item.actions.clone', {
      defaultMessage: 'Clone'
    }),
    'data-test-subj': 'sloActionsClone',
    enabled: slo => hasWriteCapabilities && !isRemote(slo) || hasRemoteKibanaUrl(slo),
    onClick: slo => {
      navigateToClone(slo);
    }
  }, {
    type: 'icon',
    icon: 'trash',
    name: buildActionName(_i18n.i18n.translate('xpack.slo.item.actions.delete', {
      defaultMessage: 'Delete'
    })),
    description: _i18n.i18n.translate('xpack.slo.item.actions.delete', {
      defaultMessage: 'Delete'
    }),
    'data-test-subj': 'sloActionsDelete',
    enabled: slo => hasWriteCapabilities && !isRemote(slo) || hasRemoteKibanaUrl(slo),
    onClick: slo => {
      const remoteDeleteUrl = (0, _remote_slo_urls.createRemoteSloDeleteUrl)(slo, spaceId);
      if (!!remoteDeleteUrl) {
        window.open(remoteDeleteUrl, '_blank');
      } else {
        setSloToDelete(slo);
      }
    }
  }];
  const columns = [{
    field: 'status',
    name: 'Status',
    render: (_, slo) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_slo_status_badge.SloStatusBadge, {
      slo: slo
    }), /*#__PURE__*/_react.default.createElement(_slo_remote_badge.SloRemoteBadge, {
      slo: slo
    }))
  }, {
    field: 'alerts',
    name: 'Alerts',
    truncateText: true,
    width: '5%',
    render: (_, slo) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_slo_rules_badge.SloRulesBadge, {
      rules: rulesBySlo === null || rulesBySlo === void 0 ? void 0 : rulesBySlo[slo.id],
      onClick: () => setSloToAddRule(slo),
      isRemote: !!slo.remote
    }), /*#__PURE__*/_react.default.createElement(_slo_active_alerts_badge.SloActiveAlertsBadge, {
      slo: slo,
      activeAlerts: activeAlertsBySlo.get(slo),
      viewMode: "compact"
    }))
  }, {
    field: 'name',
    name: 'Name',
    width: '15%',
    truncateText: {
      lines: 2
    },
    'data-test-subj': 'sloItem',
    render: (_, slo) => {
      var _slo$remote2;
      const sloDetailsUrl = basePath.prepend(_paths.paths.sloDetails(slo.id, ![slo.groupBy].flat().includes(_sloSchema.ALL_VALUE) && slo.instanceId ? slo.instanceId : undefined, (_slo$remote2 = slo.remote) === null || _slo$remote2 === void 0 ? void 0 : _slo$remote2.remoteName));
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: slo.name,
        display: "block"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("a", {
        "data-test-subj": "o11ySloListItemLink",
        href: sloDetailsUrl
      }, slo.name)));
    }
  }, {
    field: 'tags',
    name: 'Tags',
    render: tags => /*#__PURE__*/_react.default.createElement(_slo_tags_list.SloTagsList, {
      tags: tags,
      color: "default"
    })
  }, {
    field: 'instance',
    name: 'Instance',
    render: (_, slo) => {
      const groups = [slo.groupBy].flat();
      return !groups.includes(_sloSchema.ALL_VALUE) ? /*#__PURE__*/_react.default.createElement(_slo_groupings.SLOGroupings, {
        slo: slo,
        direction: "column"
      }) : /*#__PURE__*/_react.default.createElement("span", null, _i18n2.NOT_AVAILABLE_LABEL);
    }
  }, {
    field: 'objective',
    name: 'Objective',
    render: (_, slo) => (0, _numeral.default)(slo.objective.target).format('0.00%')
  }, {
    field: 'sli',
    name: 'SLI value',
    truncateText: true,
    render: (_, slo) => slo.summary.status === 'NO_DATA' ? _i18n2.NOT_AVAILABLE_LABEL : (0, _numeral.default)(slo.summary.sliValue).format(percentFormat)
  }, {
    field: 'historicalSli',
    name: 'Historical SLI',
    render: (_, slo) => {
      var _historicalSummaries$;
      const isSloFailed = ['VIOLATED', 'DEGRADING'].includes(slo.summary.status);
      const historicalSliData = (0, _chart_data_formatter.formatHistoricalData)((_historicalSummaries$ = historicalSummaries.find(historicalSummary => {
        var _slo$instanceId2;
        return historicalSummary.sloId === slo.id && historicalSummary.instanceId === ((_slo$instanceId2 = slo.instanceId) !== null && _slo$instanceId2 !== void 0 ? _slo$instanceId2 : _sloSchema.ALL_VALUE);
      })) === null || _historicalSummaries$ === void 0 ? void 0 : _historicalSummaries$.data, 'sli_value');
      return /*#__PURE__*/_react.default.createElement(_slo_sparkline.SloSparkline, {
        chart: "line",
        id: "sli_history",
        size: "compact",
        state: isSloFailed ? 'error' : 'success',
        data: historicalSliData,
        isLoading: historicalSummaryLoading
      });
    }
  }, {
    field: 'errorBudgetRemaining',
    name: 'Budget remaining',
    truncateText: true,
    render: (_, slo) => slo.summary.status === 'NO_DATA' ? _i18n2.NOT_AVAILABLE_LABEL : (0, _numeral.default)(slo.summary.errorBudget.remaining).format(percentFormat)
  }, {
    field: 'historicalErrorBudgetRemaining',
    name: 'Historical budget remaining',
    render: (_, slo) => {
      var _historicalSummaries$2;
      const isSloFailed = ['VIOLATED', 'DEGRADING'].includes(slo.summary.status);
      const errorBudgetBurnDownData = (0, _chart_data_formatter.formatHistoricalData)((_historicalSummaries$2 = historicalSummaries.find(historicalSummary => {
        var _slo$instanceId3;
        return historicalSummary.sloId === slo.id && historicalSummary.instanceId === ((_slo$instanceId3 = slo.instanceId) !== null && _slo$instanceId3 !== void 0 ? _slo$instanceId3 : _sloSchema.ALL_VALUE);
      })) === null || _historicalSummaries$2 === void 0 ? void 0 : _historicalSummaries$2.data, 'error_budget_remaining');
      return /*#__PURE__*/_react.default.createElement(_slo_sparkline.SloSparkline, {
        chart: "area",
        id: "error_budget_burn_down",
        state: isSloFailed ? 'error' : 'success',
        size: "compact",
        data: errorBudgetBurnDownData,
        isLoading: historicalSummaryLoading
      });
    }
  }, {
    name: 'Actions',
    actions,
    width: '5%'
  }];
  if (!loading && !error && sloList.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_slo_list_empty.SloListEmpty, null);
  }
  if (!loading && error) {
    return /*#__PURE__*/_react.default.createElement(_slo_list_error.SloListError, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: sloList,
    columns: columns,
    loading: loading,
    noItemsMessage: loading ? LOADING_SLOS_LABEL : NO_SLOS_FOUND,
    tableLayout: "auto"
  }), sloToAddRule ? /*#__PURE__*/_react.default.createElement(AddRuleFlyout, {
    consumer: _common.sloFeatureId,
    filteredRuleTypes: filteredRuleTypes,
    ruleTypeId: _ruleDataUtils.SLO_BURN_RATE_RULE_TYPE_ID,
    initialValues: {
      name: `${sloToAddRule.name} burn rate rule`,
      params: {
        sloId: sloToAddRule.id
      }
    },
    onSave: handleSavedRule,
    onClose: () => {
      setSloToAddRule(undefined);
    },
    useRuleProducer: true
  }) : null, sloToDelete ? /*#__PURE__*/_react.default.createElement(_slo_delete_confirmation_modal.SloDeleteConfirmationModal, {
    slo: sloToDelete,
    onCancel: handleDeleteCancel,
    onConfirm: handleDeleteConfirm
  }) : null);
}
const LOADING_SLOS_LABEL = _i18n.i18n.translate('xpack.slo.loadingSlosLabel', {
  defaultMessage: 'Loading SLOs ...'
});
const NO_SLOS_FOUND = _i18n.i18n.translate('xpack.slo.noSlosFound', {
  defaultMessage: 'No SLOs found'
});