"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GoodBadEventsChart = GoodBadEventsChart;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _public = require("@kbn/charts-plugin/public");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _kibana_react = require("../../../../utils/kibana_react");
var _get_discover_link = require("../../../../utils/slo/get_discover_link");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function GoodBadEventsChart({
  annotation,
  bottomTitle,
  data,
  slo,
  isLoading = false
}) {
  var _data$map, _data$map2;
  const {
    charts,
    uiSettings,
    discover
  } = (0, _kibana_react.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const baseTheme = charts.theme.useChartsBaseTheme();
  const chartRef = (0, _react.useRef)(null);
  const handleCursorUpdate = (0, _public.useActiveCursor)(charts.activeCursor, chartRef, {
    isDateHistogram: true
  });
  const dateFormat = uiSettings.get('dateFormat');
  const yAxisNumberFormat = '0,0';
  const domain = {
    fit: true,
    min: NaN,
    max: NaN
  };
  const intervalInMilliseconds = data && data.length > 2 ? (0, _moment.default)(data[1].date).valueOf() - (0, _moment.default)(data[0].date).valueOf() : 10 * 60000;
  const goodEventId = _i18n.i18n.translate('xpack.slo.sloDetails.eventsChartPanel.goodEventsLabel', {
    defaultMessage: 'Good events'
  });
  const badEventId = _i18n.i18n.translate('xpack.slo.sloDetails.eventsChartPanel.badEventsLabel', {
    defaultMessage: 'Bad events'
  });
  const barClickHandler = params => {
    var _slo$indicator;
    if ((slo === null || slo === void 0 ? void 0 : (_slo$indicator = slo.indicator) === null || _slo$indicator === void 0 ? void 0 : _slo$indicator.type) === 'sli.kql.custom') {
      const [datanum, eventDetail] = params[0];
      const isBad = eventDetail.specId === badEventId;
      const timeRange = {
        from: (0, _moment.default)(datanum.x).toISOString(),
        to: (0, _moment.default)(datanum.x).add(intervalInMilliseconds, 'ms').toISOString(),
        mode: 'absolute'
      };
      (0, _get_discover_link.openInDiscover)(discover, slo, isBad, !isBad, timeRange);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "m",
    mono: true,
    "data-test-subj": "sliEventsChartLoading"
  }), !isLoading && /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 150,
      width: '100%'
    },
    ref: chartRef
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.VerticalCursor
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    showLegend: true,
    showLegendExtra: false,
    legendPosition: _charts.Position.Left,
    noResults: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "visualizeApp",
      size: "l",
      color: "subdued",
      title: "no results"
    }),
    onPointerUpdate: handleCursorUpdate,
    externalPointerEvents: {
      tooltip: {
        visible: true
      }
    },
    pointerUpdateDebounce: 0,
    pointerUpdateTrigger: 'x',
    locale: _i18n.i18n.getLocale(),
    onElementClick: barClickHandler
  }), annotation, /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    title: bottomTitle,
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: d => (0, _moment.default)(d).format(dateFormat)
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left",
    position: _charts.Position.Left,
    tickFormat: d => (0, _numeral.default)(d).format(yAxisNumberFormat),
    domain: domain
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: goodEventId,
    color: euiTheme.colors.success,
    barSeriesStyle: {
      rect: {
        fill: euiTheme.colors.success
      },
      displayValue: {
        fill: euiTheme.colors.success
      }
    },
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "key",
    yAccessors: ['value'],
    stackAccessors: [0],
    data: (_data$map = data === null || data === void 0 ? void 0 : data.map(datum => {
      var _datum$events;
      return {
        key: new Date(datum.date).getTime(),
        value: (_datum$events = datum.events) === null || _datum$events === void 0 ? void 0 : _datum$events.good
      };
    })) !== null && _data$map !== void 0 ? _data$map : []
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: badEventId,
    color: euiTheme.colors.danger,
    barSeriesStyle: {
      rect: {
        fill: euiTheme.colors.danger
      },
      displayValue: {
        fill: euiTheme.colors.danger
      }
    },
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "key",
    yAccessors: ['value'],
    stackAccessors: [0],
    data: (_data$map2 = data === null || data === void 0 ? void 0 : data.map(datum => {
      var _datum$events2;
      return {
        key: new Date(datum.date).getTime(),
        value: (_datum$events2 = datum.events) === null || _datum$events2 === void 0 ? void 0 : _datum$events2.bad
      };
    })) !== null && _data$map2 !== void 0 ? _data$map2 : []
  }))));
}