"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloCardItemActions = SloCardItemActions;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _slo_item_actions = require("../slo_item_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = _styledComponents.default.div`
  ${({
  position
}) => position === 'relative' ?
// custom styles used to overlay the popover button on `MetricItem`
`
  display: inline-block;
  position: relative;
  bottom: 42px;
  left: 12px;
  z-index: 1;
` :
// otherwise, no custom position needed
''}

  border-radius: ${({
  theme
}) => theme.eui.euiBorderRadius};
  ${({
  boxShadow,
  position
}) => position === 'relative' ? boxShadow : ''}
`;
function SloCardItemActions(props) {
  const euiShadow = (0, _eui.useEuiShadow)('l');
  return /*#__PURE__*/_react.default.createElement(Container, {
    boxShadow: euiShadow,
    position: 'relative'
  }, /*#__PURE__*/_react.default.createElement(_slo_item_actions.SloItemActions, (0, _extends2.default)({}, props, {
    btnProps: {
      iconType: 'boxesHorizontal',
      color: 'primary',
      display: 'empty'
    }
  })));
}