"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloCardChart = SloCardChart;
exports.SloCardItem = SloCardItem;
exports.useSloCardColor = exports.getSubTitle = void 0;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/presentation-util-plugin/public");
var _sloSchema = require("@kbn/slo-schema");
var _react2 = _interopRequireWildcard(require("react"));
var _edit_burn_rate_rule_flyout = require("../common/edit_burn_rate_rule_flyout");
var _slo_delete_confirmation_modal = require("../../../../components/slo/delete_confirmation_modal/slo_delete_confirmation_modal");
var _kibana_react = require("../../../../utils/kibana_react");
var _chart_data_formatter = require("../../../../utils/slo/chart_data_formatter");
var _use_slo_list_actions = require("../../hooks/use_slo_list_actions");
var _use_slo_summary = require("../../hooks/use_slo_summary");
var _burn_rate_rule_flyout = require("../common/burn_rate_rule_flyout");
var _slo_card_item_actions = require("./slo_card_item_actions");
var _slo_card_item_badges = require("./slo_card_item_badges");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SavedObjectSaveModalDashboard = (0, _public.withSuspense)(_public.LazySavedObjectSaveModalDashboard);
const useSloCardColor = status => {
  const colors = {
    DEGRADING: (0, _eui.useEuiBackgroundColor)('warning'),
    VIOLATED: (0, _eui.useEuiBackgroundColor)('danger'),
    HEALTHY: (0, _eui.useEuiBackgroundColor)('success'),
    NO_DATA: (0, _eui.useEuiBackgroundColor)('subdued')
  };
  return {
    cardColor: colors[status !== null && status !== void 0 ? status : 'NO_DATA'],
    colors
  };
};
exports.useSloCardColor = useSloCardColor;
const getSubTitle = slo => {
  return getFirstGroupBy(slo);
};
exports.getSubTitle = getSubTitle;
const getFirstGroupBy = slo => {
  const firstGroupBy = Object.entries(slo.groupings).map(([key, value]) => `${key}: ${value}`)[0];
  return slo.groupBy && ![slo.groupBy].flat().includes(_sloSchema.ALL_VALUE) ? firstGroupBy : '';
};
function SloCardItem({
  slo,
  rules,
  activeAlerts,
  historicalSummary,
  refetchRules
}) {
  const containerRef = _react2.default.useRef(null);
  const [isMouseOver, setIsMouseOver] = (0, _react2.useState)(false);
  const [isActionsPopoverOpen, setIsActionsPopoverOpen] = (0, _react2.useState)(false);
  const [isAddRuleFlyoutOpen, setIsAddRuleFlyoutOpen] = (0, _react2.useState)(false);
  const [isEditRuleFlyoutOpen, setIsEditRuleFlyoutOpen] = (0, _react2.useState)(false);
  const [isDeleteConfirmationModalOpen, setDeleteConfirmationModalOpen] = (0, _react2.useState)(false);
  const [isDashboardAttachmentReady, setDashboardAttachmentReady] = (0, _react2.useState)(false);
  const historicalSliData = (0, _chart_data_formatter.formatHistoricalData)(historicalSummary, 'sli_value');
  const {
    handleCreateRule,
    handleDeleteCancel,
    handleDeleteConfirm,
    handleAttachToDashboardSave
  } = (0, _use_slo_list_actions.useSloListActions)({
    slo,
    setDeleteConfirmationModalOpen,
    setIsActionsPopoverOpen,
    setIsAddRuleFlyoutOpen
  });
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    panelRef: containerRef,
    onMouseOver: () => {
      if (!isMouseOver) {
        setIsMouseOver(true);
      }
    },
    onMouseLeave: () => {
      if (isMouseOver) {
        setIsMouseOver(false);
      }
    },
    paddingSize: "none",
    css: (0, _react.css)`
          height: 182px;
          overflow: hidden;
          position: relative;
        `,
    title: slo.summary.status
  }, /*#__PURE__*/_react2.default.createElement(SloCardChart, {
    slo: slo,
    historicalSliData: historicalSliData,
    badges: /*#__PURE__*/_react2.default.createElement(_slo_card_item_badges.SloCardItemBadges, {
      slo: slo,
      rules: rules,
      activeAlerts: activeAlerts,
      handleCreateRule: handleCreateRule,
      hasGroupBy: Boolean(slo.groupBy && slo.groupBy !== _sloSchema.ALL_VALUE)
    })
  }), (isMouseOver || isActionsPopoverOpen) && /*#__PURE__*/_react2.default.createElement(_slo_card_item_actions.SloCardItemActions, {
    slo: slo,
    rules: rules,
    isActionsPopoverOpen: isActionsPopoverOpen,
    setIsActionsPopoverOpen: setIsActionsPopoverOpen,
    setIsAddRuleFlyoutOpen: setIsAddRuleFlyoutOpen,
    setDeleteConfirmationModalOpen: setDeleteConfirmationModalOpen,
    setIsEditRuleFlyoutOpen: setIsEditRuleFlyoutOpen,
    setDashboardAttachmentReady: setDashboardAttachmentReady
  })), /*#__PURE__*/_react2.default.createElement(_burn_rate_rule_flyout.BurnRateRuleFlyout, {
    slo: slo,
    isAddRuleFlyoutOpen: isAddRuleFlyoutOpen,
    setIsAddRuleFlyoutOpen: setIsAddRuleFlyoutOpen
  }), /*#__PURE__*/_react2.default.createElement(_edit_burn_rate_rule_flyout.EditBurnRateRuleFlyout, {
    rule: rules === null || rules === void 0 ? void 0 : rules[0],
    isEditRuleFlyoutOpen: isEditRuleFlyoutOpen,
    setIsEditRuleFlyoutOpen: setIsEditRuleFlyoutOpen,
    refetchRules: refetchRules
  }), isDeleteConfirmationModalOpen ? /*#__PURE__*/_react2.default.createElement(_slo_delete_confirmation_modal.SloDeleteConfirmationModal, {
    slo: slo,
    onCancel: handleDeleteCancel,
    onConfirm: handleDeleteConfirm
  }) : null, isDashboardAttachmentReady ? /*#__PURE__*/_react2.default.createElement(SavedObjectSaveModalDashboard, {
    objectType: _i18n.i18n.translate('xpack.slo.item.actions.addToDashboard.objectTypeLabel', {
      defaultMessage: 'SLO Overview'
    }),
    documentInfo: {
      title: _i18n.i18n.translate('xpack.slo.item.actions.addToDashboard.attachmentTitle', {
        defaultMessage: 'SLO Overview'
      })
    },
    canSaveByReference: false,
    onClose: () => {
      setDashboardAttachmentReady(false);
    },
    onSave: handleAttachToDashboardSave
  }) : null);
}
function SloCardChart({
  slo,
  badges,
  onClick,
  historicalSliData
}) {
  const {
    application: {
      navigateToUrl
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    cardColor
  } = useSloCardColor(slo.summary.status);
  const subTitle = getSubTitle(slo);
  const {
    sliValue,
    sloTarget,
    sloDetailsUrl
  } = (0, _use_slo_summary.useSloFormattedSummary)(slo);
  return /*#__PURE__*/_react2.default.createElement(_charts.Chart, null, /*#__PURE__*/_react2.default.createElement(_charts.Settings
  // TODO connect to charts.theme service see src/plugins/charts/public/services/theme/README.md
  , {
    baseTheme: _charts.LEGACY_DARK_THEME,
    onElementClick: ([d]) => {
      if (onClick) {
        onClick();
      } else {
        if ((0, _charts.isMetricElementEvent)(d)) {
          navigateToUrl(sloDetailsUrl);
        }
      }
    },
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react2.default.createElement(_charts.Metric, {
    id: `${slo.id}-${slo.instanceId}`,
    data: [[{
      title: slo.name,
      subtitle: subTitle,
      value: sliValue,
      trendShape: _charts.MetricTrendShape.Area,
      trend: historicalSliData === null || historicalSliData === void 0 ? void 0 : historicalSliData.map(d => ({
        x: d.key,
        y: d.value
      })),
      extra: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.slo.sLOGridItem.targetFlexItemLabel",
        defaultMessage: "Target {target}",
        values: {
          target: sloTarget
        }
      }),
      icon: () => /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
        type: "visGauge",
        size: "l"
      }),
      color: cardColor,
      body: badges
    }]]
  }));
}