"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePutSloSettings = usePutSloSettings;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _paths = require("../../../common/locators/paths");
var _kibana_react = require("../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function usePutSloSettings() {
  const {
    application: {
      navigateToUrl
    },
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  return (0, _reactQuery.useMutation)(['putSloSettings'], ({
    settings
  }) => {
    const body = JSON.stringify(settings);
    return http.put(`/internal/slo/settings`, {
      body
    });
  }, {
    onSuccess: (data, {
      settings
    }) => {
      toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.slo.settings.successNotification', {
          defaultMessage: 'Success updated slo settings'
        })
      });
      navigateToUrl(http.basePath.prepend(_paths.paths.slos));
    },
    onError: (error, {
      settings
    }, context) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.slo.settings.errorNotification', {
          defaultMessage: 'Something went wrong while updating settings'
        })
      });
    }
  });
}