"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetSettings = void 0;
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetSettings = () => {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const {
    isLoading,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['getSloSettings'],
    queryFn: async ({
      signal
    }) => {
      try {
        return http.get('/internal/slo/settings', {
          signal
        });
      } catch (error) {
        return defaultSettings;
      }
    },
    keepPreviousData: true,
    refetchOnWindowFocus: false
  });
  return {
    isLoading,
    data
  };
};
exports.useGetSettings = useGetSettings;
const defaultSettings = {
  useAllRemoteClusters: false,
  selectedRemoteClusters: []
};