"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutdatedSloSearchBar = OutdatedSloSearchBar;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function OutdatedSloSearchBar({
  onSearch,
  onRefresh,
  initialSearch = ''
}) {
  const [tempSearch, setTempSearch] = (0, _react.useState)(initialSearch);
  const [search, setSearch] = (0, _react.useState)(initialSearch);
  const refreshOrUpdateSearch = () => {
    if (tempSearch !== search) {
      setSearch(tempSearch);
      onSearch(tempSearch);
    } else {
      onRefresh();
    }
  };
  const handleClick = event => setTempSearch(event.target.value);
  const handleKeyPress = event => {
    if (event.key === 'Enter') {
      refreshOrUpdateSearch();
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "o11ySlosOutdatedDefinitionsFieldSearch",
    fullWidth: true,
    value: tempSearch,
    onChange: handleClick,
    onKeyDown: handleKeyPress
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, search === tempSearch && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11ySlosOutdatedDefinitionsRefreshButton",
    iconType: "refresh",
    onClick: refreshOrUpdateSearch
  }, _i18n.i18n.translate('xpack.slo.slosOutdatedDefinitions.refreshButtonLabel', {
    defaultMessage: 'Refresh'
  })), search !== tempSearch && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11ySlosOutdatedDefinitionsUpdateButton",
    iconType: "kqlFunction",
    color: "success",
    fill: true,
    onClick: refreshOrUpdateSearch
  }, _i18n.i18n.translate('xpack.slo.slosOutdatedDefinitions.updateButtonLabel', {
    defaultMessage: 'Update'
  }))));
}