"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditPage = SloEditPage;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _header_menu = require("../../components/header_menu/header_menu");
var _kibana_react = require("../../utils/kibana_react");
var _paths = require("../../../common/locators/paths");
var _use_capabilities = require("../../hooks/use_capabilities");
var _use_fetch_global_diagnosis = require("../../hooks/use_fetch_global_diagnosis");
var _use_fetch_slo_details = require("../../hooks/use_fetch_slo_details");
var _use_license = require("../../hooks/use_license");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _slo_edit_form = require("./components/slo_edit_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloEditPage() {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    hasWriteCapabilities
  } = (0, _use_capabilities.useCapabilities)();
  const {
    isError: hasErrorInGlobalDiagnosis
  } = (0, _use_fetch_global_diagnosis.useFetchSloGlobalDiagnosis)();
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    sloId
  } = (0, _reactRouterDom.useParams)();
  const {
    hasAtLeast
  } = (0, _use_license.useLicense)();
  const hasRightLicense = hasAtLeast('platinum');
  const {
    data: slo
  } = (0, _use_fetch_slo_details.useFetchSloDetails)({
    sloId
  });
  (0, _public.useBreadcrumbs)([{
    href: basePath.prepend(_paths.paths.slos),
    text: _i18n.i18n.translate('xpack.slo.breadcrumbs.sloLabel', {
      defaultMessage: 'SLOs'
    }),
    deepLinkId: 'slo'
  }, ...(!!slo ? [{
    href: basePath.prepend(_paths.paths.sloDetails(slo.id)),
    text: slo.name
  }] : []), {
    text: slo ? _i18n.i18n.translate('xpack.slo.breadcrumbs.sloEditLabel', {
      defaultMessage: 'Edit'
    }) : _i18n.i18n.translate('xpack.slo.breadcrumbs.sloCreateLabel', {
      defaultMessage: 'Create'
    })
  }]);
  if (hasRightLicense === false || !hasWriteCapabilities || hasErrorInGlobalDiagnosis) {
    navigateToUrl(basePath.prepend(_paths.paths.slos));
  }
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: {
      pageTitle: slo ? _i18n.i18n.translate('xpack.slo.sloEditPageTitle', {
        defaultMessage: 'Edit SLO'
      }) : _i18n.i18n.translate('xpack.slo.sloCreatePageTitle', {
        defaultMessage: 'Create new SLO'
      }),
      bottomBorder: false
    },
    "data-test-subj": "slosEditPage"
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, null), /*#__PURE__*/_react.default.createElement(_slo_edit_form.SloEditForm, {
    slo: slo
  }));
}