"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NEW_TIMESLICE_METRIC", {
  enumerable: true,
  get: function () {
    return _metric_indicator.NEW_TIMESLICE_METRIC;
  }
});
exports.TimesliceMetricIndicatorTypeForm = TimesliceMetricIndicatorTypeForm;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _kibana_react = require("../../../../utils/kibana_react");
var _group_by_field = require("../common/group_by_field");
var _data_preview_chart = require("../common/data_preview_chart");
var _index_field_selector = require("../common/index_field_selector");
var _query_builder = require("../common/query_builder");
var _index_selection = require("../custom_common/index_selection");
var _metric_indicator = require("./metric_indicator");
var _constants = require("../../constants");
var _use_create_data_view = require("../../../../hooks/use_create_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TimesliceMetricIndicatorTypeForm() {
  var _dataView$fields;
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  const index = watch('indicator.params.index');
  const {
    dataView,
    loading: isIndexFieldsLoading
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString: index
  });
  const timestampFields = dataView === null || dataView === void 0 ? void 0 : dataView.fields.filter(field => field.type === 'date');
  const {
    uiSettings
  } = (0, _kibana_react.useKibana)().services;
  const threshold = watch('indicator.params.metric.threshold');
  const comparator = watch('indicator.params.metric.comparator');
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEdit.sliType.sourceTitle",
    defaultMessage: "Source"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_index_selection.IndexSelection, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_index_field_selector.IndexFieldSelector, {
    indexFields: timestampFields !== null && timestampFields !== void 0 ? timestampFields : [],
    name: "indicator.params.timestampField",
    label: _i18n.i18n.translate('xpack.slo.sloEdit.timestampField.label', {
      defaultMessage: 'Timestamp field'
    }),
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.timestampField.placeholder', {
      defaultMessage: 'Select a timestamp field'
    }),
    isLoading: !!index && isIndexFieldsLoading,
    isDisabled: !index,
    isRequired: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "timesliceMetricIndicatorFormQueryFilterInput",
    indexPatternString: watch('indicator.params.index'),
    label: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.queryFilter', {
      defaultMessage: 'Query filter'
    }),
    name: "indicator.params.filter",
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.customFilter', {
      defaultMessage: 'Custom filter to apply on the index'
    }),
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.customFilter.tooltip', {
        defaultMessage: 'This KQL query can be used to filter the documents with some relevant criteria.'
      }),
      position: "top"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEdit.sliType.timesliceMetric.metricTitle",
    defaultMessage: "Metric definition"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_metric_indicator.MetricIndicator, {
    indexFields: (_dataView$fields = dataView === null || dataView === void 0 ? void 0 : dataView.fields) !== null && _dataView$fields !== void 0 ? _dataView$fields : [],
    isLoadingIndex: isIndexFieldsLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_group_by_field.GroupByField, {
    dataView: dataView,
    isLoading: isIndexFieldsLoading
  }), /*#__PURE__*/_react.default.createElement(_data_preview_chart.DataPreviewChart, {
    formatPattern: uiSettings.get('format:number:defaultPattern'),
    threshold: threshold,
    thresholdDirection: ['GT', 'GTE'].includes(comparator) ? 'above' : 'below',
    thresholdColor: euiTheme.colors.warning,
    thresholdMessage: `${_constants.COMPARATOR_MAPPING[comparator]} ${threshold}`,
    ignoreMoreThan100: true
  })));
}