"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditForm = SloEditForm;
exports.maxWidth = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _slo_edit_form_footer = require("./slo_edit_form_footer");
var _constants = require("../constants");
var _process_slo_form_values = require("../helpers/process_slo_form_values");
var _use_parse_url_state = require("../hooks/use_parse_url_state");
var _use_section_form_validation = require("../hooks/use_section_form_validation");
var _use_show_sections = require("../hooks/use_show_sections");
var _slo_edit_form_description_section = require("./slo_edit_form_description_section");
var _slo_edit_form_indicator_section = require("./slo_edit_form_indicator_section");
var _slo_edit_form_objective_section = require("./slo_edit_form_objective_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maxWidth = exports.maxWidth = 775;
function SloEditForm({
  slo,
  initialValues,
  onSave
}) {
  var _useParseUrlState;
  const isEditMode = slo !== undefined;
  const sloFormValuesFromUrlState = (_useParseUrlState = (0, _use_parse_url_state.useParseUrlState)()) !== null && _useParseUrlState !== void 0 ? _useParseUrlState : initialValues;
  const sloFormValuesFromSloResponse = (0, _process_slo_form_values.transformSloResponseToCreateSloForm)(slo);
  const methods = (0, _reactHookForm.useForm)({
    defaultValues: sloFormValuesFromUrlState !== null && sloFormValuesFromUrlState !== void 0 ? sloFormValuesFromUrlState : _constants.SLO_EDIT_FORM_DEFAULT_VALUES,
    values: sloFormValuesFromUrlState ? sloFormValuesFromUrlState : sloFormValuesFromSloResponse,
    mode: 'all'
  });
  const {
    watch,
    getFieldState,
    getValues,
    formState
  } = methods;
  const {
    isIndicatorSectionValid,
    isObjectiveSectionValid,
    isDescriptionSectionValid
  } = (0, _use_section_form_validation.useSectionFormValidation)({
    getFieldState,
    getValues,
    formState,
    watch
  });
  const {
    showDescriptionSection,
    showObjectiveSection
  } = (0, _use_show_sections.useShowSections)(isEditMode, formState.isValidating, isIndicatorSectionValid, isObjectiveSectionValid);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, methods, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "sloForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: _i18n.i18n.translate('xpack.slo.sloEdit.definition.title', {
        defaultMessage: 'Define SLI'
      }),
      children: /*#__PURE__*/_react.default.createElement(_slo_edit_form_indicator_section.SloEditFormIndicatorSection, {
        isEditMode: isEditMode
      }),
      status: isIndicatorSectionValid ? 'complete' : 'incomplete'
    }, {
      title: _i18n.i18n.translate('xpack.slo.sloEdit.objectives.title', {
        defaultMessage: 'Set objectives'
      }),
      children: showObjectiveSection ? /*#__PURE__*/_react.default.createElement(_slo_edit_form_objective_section.SloEditFormObjectiveSection, null) : null,
      status: showObjectiveSection && isObjectiveSectionValid ? 'complete' : 'incomplete'
    }, {
      title: _i18n.i18n.translate('xpack.slo.sloEdit.description.title', {
        defaultMessage: 'Describe SLO'
      }),
      children: showDescriptionSection ? /*#__PURE__*/_react.default.createElement(_slo_edit_form_description_section.SloEditFormDescriptionSection, null) : null,
      status: showDescriptionSection && isDescriptionSectionValid ? 'complete' : 'incomplete'
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_slo_edit_form_footer.SloEditFormFooter, {
    slo: slo,
    onSave: onSave
  }))));
}