"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HistogramIndicatorTypeForm = HistogramIndicatorTypeForm;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_create_data_view = require("../../../../hooks/use_create_data_view");
var _group_by_field = require("../common/group_by_field");
var _data_preview_chart = require("../common/data_preview_chart");
var _index_field_selector = require("../common/index_field_selector");
var _query_builder = require("../common/query_builder");
var _index_selection = require("../custom_common/index_selection");
var _histogram_indicator = require("./histogram_indicator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HistogramIndicatorTypeForm() {
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  const index = watch('indicator.params.index');
  const {
    dataView,
    loading: isIndexFieldsLoading
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString: index
  });
  const histogramFields = dataView === null || dataView === void 0 ? void 0 : dataView.fields.filter(field => field.type === 'histogram');
  const timestampFields = dataView === null || dataView === void 0 ? void 0 : dataView.fields.filter(field => field.type === 'date');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEdit.sliType.histogram.sourceTitle",
    defaultMessage: "Source"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_index_selection.IndexSelection, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_index_field_selector.IndexFieldSelector, {
    indexFields: timestampFields !== null && timestampFields !== void 0 ? timestampFields : [],
    name: "indicator.params.timestampField",
    label: _i18n.i18n.translate('xpack.slo.sloEdit.timestampField.label', {
      defaultMessage: 'Timestamp field'
    }),
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.timestampField.placeholder', {
      defaultMessage: 'Select a timestamp field'
    }),
    isLoading: !!index && isIndexFieldsLoading,
    isDisabled: !index,
    isRequired: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "histogramIndicatorFormQueryFilterInput",
    indexPatternString: watch('indicator.params.index'),
    label: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.histogram.queryFilter', {
      defaultMessage: 'Query filter'
    }),
    name: "indicator.params.filter",
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.histogram.customFilter', {
      defaultMessage: 'Custom filter to apply on the index'
    }),
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.histogram.customFilter.tooltip', {
        defaultMessage: 'This KQL query can be used to filter the documents with some relevant criteria.'
      }),
      position: "top"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEdit.sliType.histogram.goodTitle",
    defaultMessage: "Good events"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_histogram_indicator.HistogramIndicator, {
    type: "good",
    histogramFields: histogramFields !== null && histogramFields !== void 0 ? histogramFields : [],
    isLoadingIndex: isIndexFieldsLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEdit.sliType.histogram.totalTitle",
    defaultMessage: "Total events"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_histogram_indicator.HistogramIndicator, {
    type: "total",
    histogramFields: histogramFields !== null && histogramFields !== void 0 ? histogramFields : [],
    isLoadingIndex: isIndexFieldsLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_group_by_field.GroupByField, {
    dataView: dataView,
    isLoading: isIndexFieldsLoading
  }), /*#__PURE__*/_react.default.createElement(_data_preview_chart.DataPreviewChart, null)));
}