"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricIndicator = MetricIndicator;
exports.NEW_CUSTOM_METRIC = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _aggregation_options = require("../../helpers/aggregation_options");
var _create_options = require("../../helpers/create_options");
var _query_builder = require("../common/query_builder");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NEW_CUSTOM_METRIC = exports.NEW_CUSTOM_METRIC = {
  name: 'A',
  aggregation: 'sum',
  field: ''
};
const MAX_VARIABLES = 26;
const CHAR_CODE_FOR_A = 65;
const CHAR_CODE_FOR_Z = CHAR_CODE_FOR_A + MAX_VARIABLES;
const VAR_NAMES = (0, _lodash.range)(CHAR_CODE_FOR_A, CHAR_CODE_FOR_Z).map(c => String.fromCharCode(c));
const INVALID_EQUATION_REGEX = /[^A-Z|+|\-|\s|\d+|\.|\(|\)|\/|\*|>|<|=|\?|\:|&|\!|\|]+/;
const validateEquation = value => {
  const result = value.match(INVALID_EQUATION_REGEX);
  return result === null;
};
function createEquationFromMetric(names) {
  return names.join(' + ');
}
const metricLabel = _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.metricLabel', {
  defaultMessage: 'Metric'
});
const filterLabel = _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.filterLabel', {
  defaultMessage: 'Filter'
});
const metricTooltip = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.totalMetric.tooltip', {
    defaultMessage: 'This data from this field will be aggregated with the "sum" aggregation or document count.'
  }),
  position: "top"
});
const equationLabel = _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.equationLabel', {
  defaultMessage: 'Equation'
});
const equationTooltip = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.totalEquation.tooltip', {
    defaultMessage: 'This supports basic math (A + B / C) and boolean logic (A < B ? A : B).'
  }),
  position: "top"
});
function MetricIndicator({
  type,
  metricFields,
  isLoadingIndex
}) {
  const {
    control,
    watch,
    setValue,
    register,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const [options, setOptions] = (0, _react.useState)((0, _create_options.createOptionsFromFields)(metricFields));
  const [aggregationOptions, setAggregationOptions] = (0, _react.useState)(_aggregation_options.CUSTOM_METRIC_AGGREGATION_OPTIONS);
  (0, _react.useEffect)(() => {
    setOptions((0, _create_options.createOptionsFromFields)(metricFields));
  }, [metricFields]);
  const {
    fields,
    append,
    remove
  } = (0, _reactHookForm.useFieldArray)({
    control,
    name: `indicator.params.${type}.metrics`
  });
  const equation = watch(`indicator.params.${type}.equation`);
  const indexPattern = watch('indicator.params.index');
  const disableAdd = (fields === null || fields === void 0 ? void 0 : fields.length) === MAX_VARIABLES || !indexPattern;
  const disableDelete = (fields === null || fields === void 0 ? void 0 : fields.length) === 1 || !indexPattern;
  const setDefaultEquationIfUnchanged = (previousNames, nextNames) => {
    const defaultEquation = createEquationFromMetric(previousNames);
    if (defaultEquation === equation) {
      setValue(`indicator.params.${type}.equation`, createEquationFromMetric(nextNames));
    }
  };
  const handleDeleteMetric = index => () => {
    var _fields$map;
    const currentVars = (_fields$map = fields.map(m => m.name)) !== null && _fields$map !== void 0 ? _fields$map : ['A'];
    const deletedVar = currentVars[index];
    setDefaultEquationIfUnchanged(currentVars, (0, _lodash.xor)(currentVars, [deletedVar]));
    remove(index);
  };
  const handleAddMetric = () => {
    var _fields$map2;
    const currentVars = (_fields$map2 = fields.map(m => m.name)) !== null && _fields$map2 !== void 0 ? _fields$map2 : ['A'];
    const name = (0, _lodash.first)((0, _lodash.xor)(VAR_NAMES, currentVars));
    setDefaultEquationIfUnchanged(currentVars, [...currentVars, name]);
    append({
      ...NEW_CUSTOM_METRIC,
      name
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, fields === null || fields === void 0 ? void 0 : fields.map((metric, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    key: metric.id
  }, /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({
    hidden: true
  }, register(`indicator.params.${type}.metrics.${index}.name`))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: getFieldState(`indicator.params.${type}.metrics.${index}.aggregation`).invalid,
    label: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.slo.sloEdit.customMetric.aggregationLabel', {
      defaultMessage: 'Aggregation'
    }), ' ', metric.name)
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `indicator.params.${type}.metrics.${index}.aggregation`,
    defaultValue: "sum",
    rules: {
      required: true
    },
    control: control,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
      async: true,
      fullWidth: true,
      singleSelection: {
        asPlainText: true
      },
      placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.aggregation.placeholder', {
        defaultMessage: 'Select an aggregation'
      }),
      "aria-label": _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.aggregation.placeholder', {
        defaultMessage: 'Select an aggregation'
      }),
      isClearable: true,
      isInvalid: fieldState.invalid,
      isDisabled: isLoadingIndex || !indexPattern,
      isLoading: !!indexPattern && isLoadingIndex,
      onChange: selected => {
        if (selected.length) {
          return field.onChange(selected[0].value);
        }
        field.onChange('');
      },
      selectedOptions: !!indexPattern && !!field.value && _aggregation_options.CUSTOM_METRIC_AGGREGATION_OPTIONS.some(agg => agg.value === field.value) ? [{
        value: field.value,
        label: (0, _aggregation_options.aggValueToLabel)(field.value)
      }] : [],
      onSearchChange: searchValue => {
        setAggregationOptions(_aggregation_options.CUSTOM_METRIC_AGGREGATION_OPTIONS.filter(({
          value
        }) => value.includes(searchValue)));
      },
      options: aggregationOptions
    }))
  }))), watch(`indicator.params.${type}.metrics.${index}.aggregation`) !== 'doc_count' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: getFieldState(`indicator.params.${type}.metrics.${index}.field`).invalid,
    label: /*#__PURE__*/_react.default.createElement("span", null, metricLabel, " ", metric.name, " ", metricTooltip)
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `indicator.params.${type}.metrics.${index}.field`,
    defaultValue: "",
    rules: {
      required: true
    },
    shouldUnregister: true,
    control: control,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
      async: true,
      fullWidth: true,
      singleSelection: {
        asPlainText: true
      },
      placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.metricField.placeholder', {
        defaultMessage: 'Select a metric field'
      }),
      "aria-label": _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.metricField.placeholder', {
        defaultMessage: 'Select a metric field'
      }),
      isClearable: true,
      isInvalid: fieldState.invalid,
      isDisabled: isLoadingIndex || !indexPattern,
      isLoading: !!indexPattern && isLoadingIndex,
      onChange: selected => {
        if (selected.length) {
          return field.onChange(selected[0].value);
        }
        field.onChange('');
      },
      selectedOptions: !!indexPattern && !!field.value && metricFields.some(metricField => metricField.name === field.value) ? [{
        value: field.value,
        label: field.value
      }] : [],
      onSearchChange: searchValue => {
        setOptions((0, _create_options.createOptionsFromFields)(metricFields, ({
          value
        }) => value.includes(searchValue)));
      },
      options: options
    }))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "customKqlIndicatorFormGoodQueryInput",
    indexPatternString: watch('indicator.params.index'),
    label: `${filterLabel} ${metric.name}`,
    name: `indicator.params.${type}.metrics.${index}.filter`,
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.placeholder', {
      defaultMessage: 'KQL filter'
    }),
    required: false,
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.tooltip', {
        defaultMessage: 'This KQL query should return a subset of events.'
      }),
      position: "top"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "o11yMetricIndicatorButton",
    iconType: "trash",
    color: "danger",
    style: {
      marginTop: '1.5em'
    },
    onClick: handleDeleteMetric(index),
    disabled: disableDelete,
    title: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.deleteLabel', {
      defaultMessage: 'Delete metric'
    }),
    "aria-label": _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.deleteLabel', {
      defaultMessage: 'Delete metric'
    })
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "customMetricIndicatorAddMetricButton",
    color: 'primary',
    size: "xs",
    iconType: 'plusInCircleFilled',
    onClick: handleAddMetric,
    isDisabled: disableAdd,
    "aria-label": _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.addMetricAriaLabel', {
      defaultMessage: 'Add metric'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEdit.sliType.customMetric.addMetricLabel",
    defaultMessage: "Add metric"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `indicator.params.${type}.equation`,
    defaultValue: "",
    rules: {
      required: true,
      validate: {
        validateEquation
      }
    },
    control: control,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement("span", null, equationLabel, " ", equationTooltip),
      helpText: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.equationHelpText', {
        defaultMessage: 'Supports basic math equations, valid charaters are: A-Z, +, -, /, *, (, ), ?, !, &, :, |, >, <, ='
      }),
      isInvalid: fieldState.invalid,
      error: [_i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.equation.invalidCharacters', {
        defaultMessage: 'The equation field only supports the following characters: A-Z, +, -, /, *, (, ), ?, !, &, :, |, >, <, ='
      })]
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, field, {
      isInvalid: fieldState.invalid,
      fullWidth: true,
      "data-test-subj": "o11yCustomMetricEquation"
    })))
  })));
}