"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSelection = IndexSelection;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _public = require("@kbn/unified-search-plugin/public");
var _public2 = require("@kbn/observability-plugin/public");
var _kibana_react = require("../../../../utils/kibana_react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IndexSelection() {
  const {
    control,
    getFieldState,
    setValue,
    watch
  } = (0, _reactHookForm.useFormContext)();
  const {
    dataViews: dataViewsService
  } = (0, _kibana_react.useKibana)().services;
  const {
    isLoading: isDataViewsLoading,
    data: dataViews = [],
    refetch
  } = (0, _public2.useFetchDataViews)();
  const {
    dataViewEditor
  } = (0, _kibana_react.useKibana)().services;
  const [adHocDataViews, setAdHocDataViews] = (0, _react.useState)([]);
  const currentIndexPattern = watch('indicator.params.index');
  (0, _react.useEffect)(() => {
    if (!isDataViewsLoading) {
      const missingAdHocDataView = dataViews.find(dataView => dataView.title === currentIndexPattern) || adHocDataViews.find(dataView => dataView.getIndexPattern() === currentIndexPattern);
      if (!missingAdHocDataView && currentIndexPattern) {
        async function loadMissingDataView() {
          const dataView = await dataViewsService.create({
            title: currentIndexPattern,
            allowNoIndex: true
          }, true);
          if (dataView.getIndexPattern() === currentIndexPattern) {
            setAdHocDataViews(prev => [...prev, dataView]);
          }
        }
        loadMissingDataView();
      }
    }
  }, [adHocDataViews, currentIndexPattern, dataViews, dataViewsService, isDataViewsLoading]);
  const getDataViewPatternById = id => {
    var _dataViews$find, _adHocDataViews$find;
    return ((_dataViews$find = dataViews.find(dataView => dataView.id === id)) === null || _dataViews$find === void 0 ? void 0 : _dataViews$find.title) || ((_adHocDataViews$find = adHocDataViews.find(dataView => dataView.id === id)) === null || _adHocDataViews$find === void 0 ? void 0 : _adHocDataViews$find.getIndexPattern());
  };
  const getDataViewIdByIndexPattern = indexPattern => {
    return dataViews.find(dataView => dataView.title === indexPattern) || adHocDataViews.find(dataView => dataView.getIndexPattern() === indexPattern);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: INDEX_LABEL,
    isInvalid: getFieldState('indicator.params.index').invalid
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    defaultValue: "",
    name: "indicator.params.index",
    control: control,
    rules: {
      required: true
    },
    render: ({
      field,
      fieldState
    }) => {
      var _getDataViewIdByIndex;
      return /*#__PURE__*/_react.default.createElement(_public.DataViewPicker, {
        adHocDataViews: adHocDataViews,
        trigger: {
          label: field.value || SELECT_DATA_VIEW,
          fullWidth: true,
          color: fieldState.invalid ? 'danger' : 'text',
          isLoading: isDataViewsLoading,
          'data-test-subj': 'indexSelection'
        },
        onChangeDataView: newId => {
          field.onChange(getDataViewPatternById(newId));
          dataViewsService.get(newId).then(dataView => {
            if (dataView.timeFieldName) {
              setValue('indicator.params.timestampField', dataView.timeFieldName);
            }
          });
        },
        currentDataViewId: (_getDataViewIdByIndex = getDataViewIdByIndexPattern(field.value)) === null || _getDataViewIdByIndex === void 0 ? void 0 : _getDataViewIdByIndex.id,
        onDataViewCreated: () => {
          dataViewEditor.openEditor({
            allowAdHocDataView: true,
            onSave: dataView => {
              if (!dataView.isPersisted()) {
                setAdHocDataViews([...adHocDataViews, dataView]);
                field.onChange(dataView.getIndexPattern());
              } else {
                refetch();
                field.onChange(dataView.getIndexPattern());
              }
              if (dataView.timeFieldName) {
                setValue('indicator.params.timestampField', dataView.timeFieldName);
              }
            }
          });
        }
      });
    }
  }));
}
const SELECT_DATA_VIEW = _i18n.i18n.translate('xpack.slo.sloEdit.customKql.dataViewSelection.label', {
  defaultMessage: 'Select a Data view'
});
const INDEX_LABEL = _i18n.i18n.translate('xpack.slo.sloEdit.customKql.indexSelection.label', {
  defaultMessage: 'Index'
});