"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingState = LoadingState;
exports.SLOInspectWrapper = SLOInspectWrapper;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ingest-pipelines-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _common = require("@kbn/observability-plugin/common");
var _kibana_react = require("../../../../utils/kibana_react");
var _use_fetch_slo_inspect = require("../../../../hooks/use_fetch_slo_inspect");
var _use_plugin_context = require("../../../../hooks/use_plugin_context");
var _process_slo_form_values = require("../../helpers/process_slo_form_values");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SLOInspectWrapper({
  slo,
  disabled
}) {
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana_react.useKibana)();
  const {
    isDev
  } = (0, _use_plugin_context.usePluginContext)();
  const isInspectorEnabled = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get(_common.enableInspectEsQueries);
  return isDev || isInspectorEnabled ? /*#__PURE__*/_react.default.createElement(SLOInspect, {
    slo: slo,
    disabled: disabled
  }) : null;
}
function SLOInspect({
  slo,
  disabled
}) {
  var _inspectSloData$pipel2;
  const {
    share,
    http
  } = (0, _kibana_react.useKibana)().services;
  const {
    trigger,
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const [isFormValid, setFormValid] = (0, _react.useState)(false);
  const sloFormValues = (0, _process_slo_form_values.transformCreateSLOFormToCreateSLOInput)(getValues());
  const {
    data: inspectSloData,
    isLoading
  } = (0, _use_fetch_slo_inspect.useFetchSloInspect)({
    ...sloFormValues,
    id: slo === null || slo === void 0 ? void 0 : slo.id,
    revision: slo === null || slo === void 0 ? void 0 : slo.revision
  }, isFlyoutVisible && isFormValid);
  const {
    data: pipeLineUrl
  } = (0, _public2.useFetcher)(async () => {
    var _inspectSloData$pipel;
    const ingestPipeLocator = share.url.locators.get(_public.INGEST_PIPELINES_APP_LOCATOR);
    const ingestPipeLineId = inspectSloData === null || inspectSloData === void 0 ? void 0 : (_inspectSloData$pipel = inspectSloData.pipeline) === null || _inspectSloData$pipel === void 0 ? void 0 : _inspectSloData$pipel.id;
    return ingestPipeLocator === null || ingestPipeLocator === void 0 ? void 0 : ingestPipeLocator.getUrl({
      pipelineId: ingestPipeLineId,
      page: _public.INGEST_PIPELINES_PAGES.LIST
    });
  }, [inspectSloData === null || inspectSloData === void 0 ? void 0 : (_inspectSloData$pipel2 = inspectSloData.pipeline) === null || _inspectSloData$pipel2 === void 0 ? void 0 : _inspectSloData$pipel2.id, share.url.locators]);
  const closeFlyout = () => {
    setIsFlyoutVisible(false);
    setFormValid(false);
  };
  const handleInspectButtonClick = async () => {
    const valid = await trigger();
    if (!valid) {
      setFormValid(false);
      return;
    }
    setFormValid(true);
    setIsFlyoutVisible(true);
  };
  let flyout;
  if (isFlyoutVisible) {
    flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      ownFocus: true,
      onClose: closeFlyout,
      "aria-labelledby": "flyoutTitle"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: "flyoutTitle"
    }, _i18n.i18n.translate('xpack.slo.monitorInspect.configLabel', {
      defaultMessage: 'SLO Configurations'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, isLoading && /*#__PURE__*/_react.default.createElement(LoadingState, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), inspectSloData && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(CodeBlockAccordion, {
      id: "slo",
      label: _i18n.i18n.translate('xpack.slo.sLOInspect.codeBlockAccordion.sloConfigurationLabel', {
        defaultMessage: 'SLO configuration'
      }),
      json: inspectSloData.slo
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(CodeBlockAccordion, {
      id: "rollUpTransform",
      label: _i18n.i18n.translate('xpack.slo.sLOInspect.codeBlockAccordion.rollupTransformLabel', {
        defaultMessage: 'Rollup transform'
      }),
      json: inspectSloData.rollUpTransform,
      extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "link",
        "data-test-subj": "o11ySLOInspectDetailsButton",
        href: http === null || http === void 0 ? void 0 : http.basePath.prepend('/app/management/data/transform')
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(CodeBlockAccordion, {
      id: "summaryTransform",
      label: _i18n.i18n.translate('xpack.slo.sLOInspect.codeBlockAccordion.summaryTransformLabel', {
        defaultMessage: 'Summary transform'
      }),
      json: inspectSloData.summaryTransform,
      extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "link",
        "data-test-subj": "o11ySLOInspectDetailsButton",
        href: http === null || http === void 0 ? void 0 : http.basePath.prepend('/app/management/data/transform')
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(CodeBlockAccordion, {
      id: "pipeline",
      label: _i18n.i18n.translate('xpack.slo.sLOInspect.codeBlockAccordion.ingestPipelineLabel', {
        defaultMessage: 'SLO Ingest pipeline'
      }),
      extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "link",
        "data-test-subj": "o11ySLOInspectDetailsButton",
        href: pipeLineUrl
      }),
      json: inspectSloData.pipeline
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(CodeBlockAccordion, {
      id: "temporaryDoc",
      label: _i18n.i18n.translate('xpack.slo.sLOInspect.codeBlockAccordion.temporaryDocumentLabel', {
        defaultMessage: 'Temporary document'
      }),
      json: inspectSloData.temporaryDoc
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "syntheticsMonitorInspectCloseButton",
      onClick: closeFlyout,
      fill: true
    }, _i18n.i18n.translate('xpack.slo.sLOInspect.closeButtonLabel', {
      defaultMessage: 'Close'
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isFormValid ? _i18n.i18n.translate('xpack.slo.viewFormattedResourcesConfigsButtonLabel', {
      defaultMessage: 'View formatted resources configs for SLO'
    }) : _i18n.i18n.translate('xpack.slo.formattedConfigLabel.valid', {
      defaultMessage: 'Only valid form configurations can be inspected.'
    }),
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    "data-test-subj": "syntheticsMonitorInspectShowFlyoutExampleButton",
    onClick: handleInspectButtonClick,
    disabled: disabled,
    iconType: "inspect",
    iconSide: "left"
  }, _i18n.i18n.translate('xpack.slo.sLOInspect.sLOInspectButtonLabel', {
    defaultMessage: 'SLO Inspect'
  }))), flyout);
}
function CodeBlockAccordion({
  id,
  label,
  json,
  extraAction
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: id,
    extraAction: extraAction,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, label))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    fontSize: "m",
    paddingSize: "m",
    isCopyable: true
  }, JSON.stringify(json, null, 2)));
}
function LoadingState() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    style: {
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  })));
}