"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuerySearchBar = void 0;
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _esQuery = require("@kbn/es-query");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common = require("@kbn/observability-shared-plugin/common");
var _use_create_data_view = require("../../../../hooks/use_create_data_view");
var _kibana_react = require("../../../../utils/kibana_react");
var _optional_text = require("./optional_text");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QuerySearchBar = exports.QuerySearchBar = /*#__PURE__*/(0, _react.memo)(({
  isFlyoutOpen,
  name,
  label,
  indexPatternString,
  required,
  tooltip,
  dataTestSubj,
  placeholder,
  range,
  setRange
}) => {
  const {
    SearchBar
  } = (0, _kibana_react.useKibana)().services.unifiedSearch.ui;
  const {
    dataView
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString
  });
  const {
    control
  } = (0, _reactHookForm.useFormContext)();
  return /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    defaultValue: "",
    name: name,
    control: control,
    rules: {
      required: Boolean(required) && Boolean(dataView),
      validate: value => {
        try {
          if (!dataView) return;
          if (typeof value === 'string') {
            const ast = (0, _esQuery.fromKueryExpression)(value);
            (0, _esQuery.toElasticsearchQuery)(ast, dataView);
          } else if (_sloSchema.kqlWithFiltersSchema.is(value)) {
            const ast = (0, _esQuery.fromKueryExpression)(value.kqlQuery);
            (0, _esQuery.toElasticsearchQuery)(ast, dataView);
          }
        } catch (e) {
          return e.message;
        }
      }
    },
    render: ({
      field,
      fieldState
    }) => {
      var _fieldState$error, _field$value$filters, _field$value3;
      const handleQueryChange = (value, nRange) => {
        if (isFlyoutOpen && nRange) {
          setRange(nRange);
        }
        if (_sloSchema.kqlQuerySchema.is(field.value)) {
          field.onChange(String(value === null || value === void 0 ? void 0 : value.query));
        } else {
          var _field$value;
          field.onChange({
            ...((_field$value = field.value) !== null && _field$value !== void 0 ? _field$value : {}),
            kqlQuery: String(value === null || value === void 0 ? void 0 : value.query)
          });
        }
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: !!tooltip ? /*#__PURE__*/_react.default.createElement("span", null, label, " ", tooltip) : label,
        labelAppend: !required ? /*#__PURE__*/_react.default.createElement(_optional_text.OptionalText, null) : undefined,
        isInvalid: fieldState.invalid,
        error: (_fieldState$error = fieldState.error) === null || _fieldState$error === void 0 ? void 0 : _fieldState$error.message,
        fullWidth: true
      }, /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(SearchBar, {
        appName: _common.observabilityAppId,
        dataTestSubj: dataTestSubj,
        indexPatterns: dataView ? [dataView] : [],
        isDisabled: !dataView,
        placeholder: placeholder,
        query: {
          query: _sloSchema.kqlQuerySchema.is(field.value) ? String(field.value) : field.value.kqlQuery,
          language: 'kuery'
        }
        // we rely on submit button to submit the form when the flyout is open
        ,
        onQueryChange: isFlyoutOpen ? undefined : value => handleQueryChange(value.query, value.dateRange),
        onQuerySubmit: value => handleQueryChange(value.query, value.dateRange),
        onFiltersUpdated: filters => {
          if (_sloSchema.kqlQuerySchema.is(field.value)) {
            field.onChange({
              filters,
              kqlQuery: field.value
            });
          } else {
            var _field$value2;
            field.onChange({
              ...((_field$value2 = field.value) !== null && _field$value2 !== void 0 ? _field$value2 : {}),
              filters
            });
          }
        },
        onSavedQueryUpdated: savedQuery => {
          field.onChange({
            filters: savedQuery.attributes.filters,
            kqlQuery: String(savedQuery.attributes.query.query)
          });
        },
        dateRangeFrom: range.from,
        dateRangeTo: range.to,
        onTimeRangeChange: nRange => {
          setRange(nRange.dateRange);
        },
        showDatePicker: isFlyoutOpen,
        showSubmitButton: isFlyoutOpen,
        showQueryInput: true,
        disableQueryLanguageSwitcher: true,
        onClearSavedQuery: () => {},
        filters: _sloSchema.kqlQuerySchema.is(field.value) ? [] : (_field$value$filters = (_field$value3 = field.value) === null || _field$value3 === void 0 ? void 0 : _field$value3.filters) !== null && _field$value$filters !== void 0 ? _field$value$filters : []
      })));
    }
  });
});
const Container = _styledComponents.default.div`
  .uniSearchBar {
    padding: 0;
  }
`;