"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryBuilder = QueryBuilder;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _query_search_bar = require("./query_search_bar");
var _query_documents_flyout = require("./query_documents_flyout");
var _use_create_data_view = require("../../../../hooks/use_create_data_view");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function QueryBuilder(props) {
  const {
    indexPatternString,
    name
  } = props;
  const {
    dataView
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString
  });
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react.useState)(false);
  const [range, setRange] = (0, _react.useState)({
    from: 'now-15m',
    to: 'now'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_search_bar.QuerySearchBar, (0, _extends2.default)({}, props, {
    setRange: setRange,
    range: range,
    isFlyoutOpen: isFlyoutOpen
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    css: {
      marginTop: 27
    },
    isDisabled: !Boolean(dataView),
    "data-test-subj": "o11yQueryBuilderButton",
    iconType: "documents",
    onClick: () => setIsFlyoutOpen(true),
    "aria-label": _i18n.i18n.translate('xpack.slo.queryBuilder.documentsButtonLabel', {
      defaultMessage: 'View documents'
    })
  }))), isFlyoutOpen && dataView && /*#__PURE__*/_react.default.createElement(_query_documents_flyout.QueryDocumentsFlyout, {
    range: range,
    setRange: setRange,
    setIsFlyoutOpen: setIsFlyoutOpen,
    dataView: dataView,
    name: name,
    searchBarProps: props
  }));
}