"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupByField = GroupByField;
exports.canGroupBy = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _optional_text = require("./optional_text");
var _index_field_selector = require("./index_field_selector");
var _group_by_cardinality = require("./group_by_cardinality");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function GroupByField({
  dataView,
  isLoading,
  filters
}) {
  var _dataView$fields$filt, _dataView$fields;
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  const groupByFields = (_dataView$fields$filt = dataView === null || dataView === void 0 ? void 0 : (_dataView$fields = dataView.fields) === null || _dataView$fields === void 0 ? void 0 : _dataView$fields.filter(field => canGroupBy(field))) !== null && _dataView$fields$filt !== void 0 ? _dataView$fields$filt : [];
  const index = watch('indicator.params.index');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_index_field_selector.IndexFieldSelector, {
    indexFields: groupByFields,
    name: "groupBy",
    defaultValue: _sloSchema.ALL_VALUE,
    label: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.slo.sloEdit.groupBy.label', {
      defaultMessage: 'Group by'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.groupBy.tooltip', {
        defaultMessage: 'Create individual SLOs for each value of the selected field.'
      }),
      position: "top"
    })),
    labelAppend: /*#__PURE__*/_react.default.createElement(_optional_text.OptionalText, null),
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.groupBy.placeholder', {
      defaultMessage: 'Select an optional field to group by'
    }),
    isLoading: !!index && isLoading,
    isDisabled: !index
  }), /*#__PURE__*/_react.default.createElement(_group_by_cardinality.GroupByCardinality, {
    customFilters: filters
  }));
}
const canGroupBy = field => {
  var _field$esTypes;
  const isAggregatable = field.aggregatable;
  const isNotDate = field.type !== 'date';
  // handles multi fields where there are multi es types, which could include 'text'
  // text fields break the transforms so we must ensure that the field is only a keyword
  const isOnlyKeyword = ((_field$esTypes = field.esTypes) === null || _field$esTypes === void 0 ? void 0 : _field$esTypes.length) === 1 && field.esTypes[0] === 'keyword';
  return isAggregatable && isNotDate && isOnlyKeyword;
};
exports.canGroupBy = canGroupBy;