"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSloDetailsTabs = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _sloSchema = require("@kbn/slo-schema");
var _use_fetch_active_alerts = require("../../../hooks/use_fetch_active_alerts");
var _slo_details = require("../components/slo_details");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSloDetailsTabs = ({
  slo,
  isAutoRefreshing,
  selectedTabId,
  setSelectedTabId
}) => {
  var _slo$instanceId, _ref;
  const {
    data: activeAlerts
  } = (0, _use_fetch_active_alerts.useFetchActiveAlerts)({
    sloIdsAndInstanceIds: slo ? [[slo.id, (_slo$instanceId = slo.instanceId) !== null && _slo$instanceId !== void 0 ? _slo$instanceId : _sloSchema.ALL_VALUE]] : [],
    shouldRefetch: isAutoRefreshing
  });
  const isRemote = !!(slo !== null && slo !== void 0 && slo.remote);
  const tabs = [{
    id: _slo_details.OVERVIEW_TAB_ID,
    label: _i18n.i18n.translate('xpack.slo.sloDetails.tab.overviewLabel', {
      defaultMessage: 'Overview'
    }),
    'data-test-subj': 'overviewTab',
    isSelected: selectedTabId === _slo_details.OVERVIEW_TAB_ID,
    onClick: () => setSelectedTabId(_slo_details.OVERVIEW_TAB_ID)
  }, {
    id: _slo_details.ALERTS_TAB_ID,
    label: isRemote ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.slo.sloDetails.tab.alertsDisabledTooltip', {
        defaultMessage: 'Alerts are not available for remote SLOs'
      }),
      position: "right"
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ALERTS_LABEL)) : ALERTS_LABEL,
    'data-test-subj': 'alertsTab',
    disabled: Boolean(isRemote),
    isSelected: selectedTabId === _slo_details.ALERTS_TAB_ID,
    append: slo && !isRemote ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      className: "eui-alignCenter",
      size: "m"
    }, (_ref = activeAlerts && activeAlerts.get(slo)) !== null && _ref !== void 0 ? _ref : 0) : null,
    onClick: () => setSelectedTabId(_slo_details.ALERTS_TAB_ID)
  }];
  return {
    tabs
  };
};
exports.useSloDetailsTabs = useSloDetailsTabs;
const ALERTS_LABEL = _i18n.i18n.translate('xpack.slo.sloDetails.tab.alertsLabel', {
  defaultMessage: 'Alerts'
});