"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OVERVIEW_TAB_ID = exports.ALERTS_TAB_ID = void 0;
exports.SloDetails = SloDetails;
exports.TAB_ID_URL_PARAM = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireWildcard(require("react"));
var _burn_rates = require("../../../components/slo/burn_rate/burn_rates");
var _use_fetch_historical_summary = require("../../../hooks/use_fetch_historical_summary");
var _use_fetch_rules_for_slo = require("../../../hooks/use_fetch_rules_for_slo");
var _chart_data_formatter = require("../../../utils/slo/chart_data_formatter");
var _error_budget_chart_panel = require("./error_budget_chart_panel");
var _events_chart_panel = require("./events_chart_panel");
var _overview = require("./overview/overview");
var _sli_chart_panel = require("./sli_chart_panel");
var _slo_detail_alerts = require("./slo_detail_alerts");
var _slo_remote_callout = require("./slo_remote_callout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TAB_ID_URL_PARAM = exports.TAB_ID_URL_PARAM = 'tabId';
const OVERVIEW_TAB_ID = exports.OVERVIEW_TAB_ID = 'overview';
const ALERTS_TAB_ID = exports.ALERTS_TAB_ID = 'alerts';
const DAY_IN_MILLISECONDS = 24 * 60 * 60 * 1000;
const DEFAULT_BURN_RATE_OPTIONS = [{
  id: (0, _eui.htmlIdGenerator)()(),
  label: _i18n.i18n.translate('xpack.slo.burnRates.fromRange.label', {
    defaultMessage: '{duration}h',
    values: {
      duration: 1
    }
  }),
  windowName: 'CRITICAL',
  threshold: 14.4,
  duration: 1
}, {
  id: (0, _eui.htmlIdGenerator)()(),
  label: _i18n.i18n.translate('xpack.slo.burnRates.fromRange.label', {
    defaultMessage: '{duration}h',
    values: {
      duration: 6
    }
  }),
  windowName: 'HIGH',
  threshold: 6,
  duration: 6
}, {
  id: (0, _eui.htmlIdGenerator)()(),
  label: _i18n.i18n.translate('xpack.slo.burnRates.fromRange.label', {
    defaultMessage: '{duration}h',
    values: {
      duration: 24
    }
  }),
  windowName: 'MEDIUM',
  threshold: 3,
  duration: 24
}, {
  id: (0, _eui.htmlIdGenerator)()(),
  label: _i18n.i18n.translate('xpack.slo.burnRates.fromRange.label', {
    defaultMessage: '{duration}h',
    values: {
      duration: 72
    }
  }),
  windowName: 'LOW',
  threshold: 1,
  duration: 72
}];
function SloDetails({
  slo,
  isAutoRefreshing,
  selectedTabId
}) {
  var _rules$slo$id$0$param, _rules$slo$id, _rules$slo$id$, _rules$slo$id$$params, _rules$slo$id$$params2;
  const {
    data: rules
  } = (0, _use_fetch_rules_for_slo.useFetchRulesForSlo)({
    sloIds: [slo.id]
  });
  const burnRateOptions = (_rules$slo$id$0$param = rules === null || rules === void 0 ? void 0 : (_rules$slo$id = rules[slo.id]) === null || _rules$slo$id === void 0 ? void 0 : (_rules$slo$id$ = _rules$slo$id[0]) === null || _rules$slo$id$ === void 0 ? void 0 : (_rules$slo$id$$params = _rules$slo$id$.params) === null || _rules$slo$id$$params === void 0 ? void 0 : (_rules$slo$id$$params2 = _rules$slo$id$$params.windows) === null || _rules$slo$id$$params2 === void 0 ? void 0 : _rules$slo$id$$params2.map(window => ({
    id: (0, _eui.htmlIdGenerator)()(),
    label: _i18n.i18n.translate('xpack.slo.burnRates.fromRange.label', {
      defaultMessage: '{duration}h',
      values: {
        duration: window.longWindow.value
      }
    }),
    windowName: window.actionGroup,
    threshold: window.burnRateThreshold,
    duration: window.longWindow.value
  }))) !== null && _rules$slo$id$0$param !== void 0 ? _rules$slo$id$0$param : DEFAULT_BURN_RATE_OPTIONS;
  const {
    data: historicalSummaries = [],
    isLoading: historicalSummaryLoading
  } = (0, _use_fetch_historical_summary.useFetchHistoricalSummary)({
    sloList: [slo],
    shouldRefetch: isAutoRefreshing
  });
  const sloHistoricalSummary = historicalSummaries.find(historicalSummary => {
    var _slo$instanceId;
    return historicalSummary.sloId === slo.id && historicalSummary.instanceId === ((_slo$instanceId = slo.instanceId) !== null && _slo$instanceId !== void 0 ? _slo$instanceId : _sloSchema.ALL_VALUE);
  });
  const [range, setRange] = (0, _react.useState)({
    start: new Date().getTime() - DAY_IN_MILLISECONDS,
    end: new Date().getTime()
  });
  (0, _react.useEffect)(() => {
    let intervalId;
    if (isAutoRefreshing) {
      intervalId = setInterval(() => {
        setRange({
          start: new Date().getTime() - DAY_IN_MILLISECONDS,
          end: new Date().getTime()
        });
      }, 60 * 1000);
    }
    return () => clearInterval(intervalId);
  }, [isAutoRefreshing]);
  const errorBudgetBurnDownData = (0, _chart_data_formatter.formatHistoricalData)(sloHistoricalSummary === null || sloHistoricalSummary === void 0 ? void 0 : sloHistoricalSummary.data, 'error_budget_remaining');
  const historicalSliData = (0, _chart_data_formatter.formatHistoricalData)(sloHistoricalSummary === null || sloHistoricalSummary === void 0 ? void 0 : sloHistoricalSummary.data, 'sli_value');
  return selectedTabId === OVERVIEW_TAB_ID ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_slo_remote_callout.SloRemoteCallout, {
    slo: slo
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_overview.Overview, {
    slo: slo
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_burn_rates.BurnRates, {
    slo: slo,
    isAutoRefreshing: isAutoRefreshing,
    burnRateOptions: burnRateOptions
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_sli_chart_panel.SliChartPanel, {
    data: historicalSliData,
    isLoading: historicalSummaryLoading,
    slo: slo
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_error_budget_chart_panel.ErrorBudgetChartPanel, {
    data: errorBudgetBurnDownData,
    isLoading: historicalSummaryLoading,
    slo: slo
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_events_chart_panel.EventsChartPanel, {
    slo: slo,
    range: range
  })))) : /*#__PURE__*/_react.default.createElement(_slo_detail_alerts.SloDetailsAlerts, {
    slo: slo
  });
}