"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsIndicatorOverview = SyntheticsIndicatorOverview;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _kibana_react = require("../../../../utils/kibana_react");
var _overview_item = require("./overview_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SyntheticsIndicatorOverview({
  slo
}) {
  var _slo$meta;
  const {
    share: {
      url: {
        locators
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  const locator = locators.get(_common.syntheticsMonitorDetailLocatorID);
  const {
    'monitor.name': name,
    'observer.geo.name': location
  } = slo.groupings;
  const {
    configId,
    locationId
  } = ((_slo$meta = slo.meta) === null || _slo$meta === void 0 ? void 0 : _slo$meta.synthetics) || {};
  const indicator = slo.indicator;
  if (!_sloSchema.syntheticsAvailabilityIndicatorSchema.is(indicator)) {
    return null;
  }
  const onMonitorClick = () => locator === null || locator === void 0 ? void 0 : locator.navigate({
    configId,
    locationId
  });
  const showOverviewItem = name || location;
  if (!showOverviewItem) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: MONITOR_LABEL,
    subtitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "flexStart",
      gutterSize: "s",
      responsive: false,
      wrap: true
    }, name && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      onClick: onMonitorClick,
      iconOnClick: onMonitorClick,
      onClickAriaLabel: MONITOR_ARIA_LABEL,
      iconOnClickAriaLabel: MONITOR_ARIA_LABEL
    }, _i18n.i18n.translate('xpack.slo.sloDetails.overview.syntheticsMonitor.name', {
      defaultMessage: 'Name: {value}',
      values: {
        value: name
      }
    }))), location && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, _i18n.i18n.translate('xpack.slo.sloDetails.overview.syntheticsMonitor.locationName', {
      defaultMessage: 'Location: {value}',
      values: {
        value: location
      }
    }))))
  });
}
const MONITOR_LABEL = _i18n.i18n.translate('xpack.slo.sloDetails.overview.syntheticsMonitor', {
  defaultMessage: 'Synthetics monitor'
});
const MONITOR_ARIA_LABEL = _i18n.i18n.translate('xpack.slo.sloDetails.overview.syntheticsMonitorDetails', {
  defaultMessage: 'Synthetics monitor details'
});