"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderTitle = HeaderTitle;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _slo_remote_badge = require("../../slos/components/badges/slo_remote_badge");
var _slo_groupings = require("../../slos/components/common/slo_groupings");
var _slo_status_badge = require("../../../components/slo/slo_status_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HeaderTitle({
  isLoading,
  slo
}) {
  if (isLoading || !slo) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1,
      "data-test-subj": "loadingTitle"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_slo_groupings.SLOGroupings, {
    slo: slo
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexStart",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_slo_status_badge.SloStatusBadge, {
    slo: slo
  }), /*#__PURE__*/_react.default.createElement(_slo_remote_badge.SloRemoteBadge, {
    slo: slo
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.slo.sloDetails.headerTitle.lastUpdatedMessage', {
    defaultMessage: 'Last updated on'
  })), "\xA0", (0, _moment.default)(slo.updatedAt).format('ll'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.slo.sloDetails.headerTitle.createdMessage', {
    defaultMessage: 'Created on'
  })), "\xA0", (0, _moment.default)(slo.createdAt).format('ll')))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
}