"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateSlo = useUpdateSlo;
var _i18n = require("@kbn/i18n");
var _rison = require("@kbn/rison");
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../utils/kibana_react");
var _paths = require("../../common/locators/paths");
var _query_key_factory = require("./query_key_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useUpdateSlo() {
  const {
    application: {
      navigateToUrl
    },
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)(['updateSlo'], ({
    sloId,
    slo
  }) => {
    const body = JSON.stringify(slo);
    return http.put(`/api/observability/slos/${sloId}`, {
      body
    });
  }, {
    onSuccess: (_data, {
      slo: {
        name
      }
    }) => {
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.lists(),
        exact: false
      });
      toasts.addSuccess(_i18n.i18n.translate('xpack.slo.update.successNotification', {
        defaultMessage: 'Successfully updated {name}',
        values: {
          name
        }
      }));
    },
    onError: (error, {
      slo,
      sloId
    }, context) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.slo.update.errorNotification', {
          defaultMessage: 'Something went wrong when updating {name}',
          values: {
            name: slo.name
          }
        })
      });
      navigateToUrl(http.basePath.prepend(_paths.paths.sloEditWithEncodedForm(sloId, (0, _rison.encode)(slo))));
    }
  });
}