"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSloInspect = useFetchSloInspect;
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSloInspect(slo, shouldInspect) {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const {
    isLoading,
    isError,
    isSuccess,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['slo', 'inspect'],
    queryFn: async ({
      signal
    }) => {
      try {
        const body = JSON.stringify(slo);
        const response = await http.post('/internal/api/observability/slos/_inspect', {
          body,
          signal
        });
        return response;
      } catch (error) {
        // ignore error
      }
    },
    enabled: shouldInspect,
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  return {
    data,
    isLoading,
    isSuccess,
    isError
  };
}