"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchHistoricalSummary = useFetchHistoricalSummary;
var _reactQuery = require("@tanstack/react-query");
var _sloSchema = require("@kbn/slo-schema");
var _kibana_react = require("../utils/kibana_react");
var _query_key_factory = require("./query_key_factory");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchHistoricalSummary({
  sloList = [],
  shouldRefetch
}) {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const list = sloList.map(slo => {
    var _slo$instanceId, _slo$remote;
    return {
      sloId: slo.id,
      instanceId: (_slo$instanceId = slo.instanceId) !== null && _slo$instanceId !== void 0 ? _slo$instanceId : _sloSchema.ALL_VALUE,
      remoteName: (_slo$remote = slo.remote) === null || _slo$remote === void 0 ? void 0 : _slo$remote.remoteName,
      timeWindow: slo.timeWindow,
      groupBy: slo.groupBy,
      revision: slo.revision,
      objective: slo.objective,
      budgetingMethod: slo.budgetingMethod
    };
  });
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.historicalSummary(list),
    queryFn: async ({
      signal
    }) => {
      try {
        const response = await http.post('/internal/observability/slos/_historical_summary', {
          body: JSON.stringify({
            list
          }),
          signal
        });
        return response;
      } catch (error) {
        // ignore error
      }
    },
    enabled: Boolean(list.length > 0),
    refetchInterval: shouldRefetch ? _constants.SLO_LONG_REFETCH_INTERVAL : undefined,
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  return {
    data,
    isLoading,
    isRefetching,
    isInitialLoading,
    isSuccess,
    isError
  };
}