"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateDataView = useCreateDataView;
var _react = require("react");
var _kibana_react = require("../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCreateDataView({
  indexPatternString
}) {
  const {
    dataViews
  } = (0, _kibana_react.useKibana)().services;
  const [stateDataView, setStateDataView] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const createDataView = () => dataViews.create({
      id: `${indexPatternString}-id`,
      title: indexPatternString,
      allowNoIndex: true
    });
    if (indexPatternString) {
      setIsLoading(true);
      createDataView().then(value => {
        setStateDataView(value);
      }).finally(() => {
        setIsLoading(false);
      });
    }
  }, [indexPatternString, dataViews]);
  return {
    dataView: stateDataView,
    loading: isLoading
  };
}