"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingContent = exports.LoadingContainer = void 0;
exports.SloOverview = SloOverview;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _sloSchema = require("@kbn/slo-schema");
var _slo_overview_details = require("../common/slo_overview_details");
var _chart_data_formatter = require("../../../utils/slo/chart_data_formatter");
var _use_fetch_historical_summary = require("../../../hooks/use_fetch_historical_summary");
var _use_fetch_active_alerts = require("../../../hooks/use_fetch_active_alerts");
var _use_fetch_rules_for_slo = require("../../../hooks/use_fetch_rules_for_slo");
var _slo_card_item_badges = require("../../../pages/slos/components/card_view/slo_card_item_badges");
var _slo_card_item = require("../../../pages/slos/components/card_view/slo_card_item");
var _use_fetch_slo_details = require("../../../hooks/use_fetch_slo_details");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloOverview({
  sloId,
  sloInstanceId,
  remoteName,
  onRenderComplete,
  reloadSubject
}) {
  var _slo$instanceId, _historicalSummaries$;
  const [lastRefreshTime, setLastRefreshTime] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    reloadSubject === null || reloadSubject === void 0 ? void 0 : reloadSubject.subscribe(() => {
      setLastRefreshTime(Date.now());
    });
    return () => {
      reloadSubject === null || reloadSubject === void 0 ? void 0 : reloadSubject.unsubscribe();
    };
  }, [reloadSubject]);
  const {
    isLoading,
    data: slo,
    refetch,
    isRefetching
  } = (0, _use_fetch_slo_details.useFetchSloDetails)({
    sloId,
    remoteName,
    instanceId: sloInstanceId
  });
  const {
    data: rulesBySlo
  } = (0, _use_fetch_rules_for_slo.useFetchRulesForSlo)({
    sloIds: sloId ? [sloId] : []
  });
  const {
    data: activeAlertsBySlo
  } = (0, _use_fetch_active_alerts.useFetchActiveAlerts)({
    sloIdsAndInstanceIds: slo ? [[slo.id, (_slo$instanceId = slo.instanceId) !== null && _slo$instanceId !== void 0 ? _slo$instanceId : _sloSchema.ALL_VALUE]] : []
  });
  const {
    data: historicalSummaries = []
  } = (0, _use_fetch_historical_summary.useFetchHistoricalSummary)({
    sloList: slo ? [slo] : []
  });
  const [selectedSlo, setSelectedSlo] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    refetch();
  }, [lastRefreshTime, refetch]);
  (0, _react.useEffect)(() => {
    if (!onRenderComplete) return;
    if (!isLoading) {
      onRenderComplete();
    }
  }, [isLoading, onRenderComplete]);
  const isSloNotFound = !isLoading && slo === undefined;
  if (isRefetching || isLoading || !slo) {
    return /*#__PURE__*/_react.default.createElement(LoadingContainer, null, /*#__PURE__*/_react.default.createElement(LoadingContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, null)));
  }
  if (isSloNotFound) {
    return /*#__PURE__*/_react.default.createElement(LoadingContainer, null, /*#__PURE__*/_react.default.createElement(LoadingContent, null, _i18n.i18n.translate('xpack.slo.sloEmbeddable.overview.sloNotFoundText', {
      defaultMessage: 'The SLO has been deleted. You can safely delete the widget from the dashboard.'
    })));
  }
  const rules = rulesBySlo === null || rulesBySlo === void 0 ? void 0 : rulesBySlo[slo === null || slo === void 0 ? void 0 : slo.id];
  const activeAlerts = activeAlertsBySlo.get(slo);
  const hasGroupBy = Boolean(slo.groupBy && slo.groupBy !== _sloSchema.ALL_VALUE);
  const historicalSummary = (_historicalSummaries$ = historicalSummaries.find(histSummary => {
    var _slo$instanceId2;
    return histSummary.sloId === slo.id && histSummary.instanceId === ((_slo$instanceId2 = slo.instanceId) !== null && _slo$instanceId2 !== void 0 ? _slo$instanceId2 : _sloSchema.ALL_VALUE);
  })) === null || _historicalSummaries$ === void 0 ? void 0 : _historicalSummaries$.data;
  const historicalSliData = (0, _chart_data_formatter.formatHistoricalData)(historicalSummary, 'sli_value');
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_slo_card_item.SloCardChart, {
    slo: slo,
    historicalSliData: historicalSliData !== null && historicalSliData !== void 0 ? historicalSliData : [],
    onClick: () => {
      setSelectedSlo(slo);
    },
    badges: /*#__PURE__*/_react.default.createElement(_slo_card_item_badges.SloCardItemBadges, {
      slo: slo,
      rules: rules,
      activeAlerts: activeAlerts,
      hasGroupBy: hasGroupBy
    })
  }), /*#__PURE__*/_react.default.createElement(_slo_overview_details.SloOverviewDetails, {
    slo: selectedSlo,
    setSelectedSlo: setSelectedSlo
  }));
}
const LoadingContainer = exports.LoadingContainer = _common.euiStyled.div`
  position: relative;
  overflow: hidden;
  display: flex;
  flex-direction: column;
  justify-content: center;
  width: 100%;
  height: 100%;
`;
const LoadingContent = exports.LoadingContent = _common.euiStyled.div`
  flex: 0 0 auto;
  align-self: center;
  text-align: center;
`;