"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloOverviewEmbeddableFactoryDefinition = exports.COMMON_SLO_GROUPING = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _slo_embeddable = require("./slo_embeddable");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const COMMON_SLO_GROUPING = exports.COMMON_SLO_GROUPING = [{
  id: 'slos',
  getDisplayName: () => 'SLOs',
  getIconType: () => {
    return 'visGauge';
  }
}];
class SloOverviewEmbeddableFactoryDefinition {
  constructor(getStartServices) {
    (0, _defineProperty2.default)(this, "type", _slo_embeddable.SLO_EMBEDDABLE);
    (0, _defineProperty2.default)(this, "grouping", COMMON_SLO_GROUPING);
    (0, _defineProperty2.default)(this, "getPanelPlacementSettings", input => {
      if (input.showAllGroupByInstances || input.groupFilters) {
        return {
          width: 24,
          height: 8
        };
      }
      return {
        width: 12,
        height: 8
      };
    });
    this.getStartServices = getStartServices;
  }
  async isEditable() {
    return true;
  }
  async getExplicitInput() {
    const [coreStart, pluginStart] = await this.getStartServices();
    try {
      const {
        resolveEmbeddableSloUserInput
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./handle_explicit_input')));
      return await resolveEmbeddableSloUserInput(coreStart, pluginStart);
    } catch (e) {
      return Promise.reject();
    }
  }
  async create(initialInput, parent) {
    try {
      const [coreStart, pluginStart] = await this.getStartServices();
      return new _slo_embeddable.SLOEmbeddable({
        ...coreStart,
        ...pluginStart
      }, initialInput, parent);
    } catch (e) {
      return new _public.ErrorEmbeddable(e, initialInput, parent);
    }
  }
  getDescription() {
    return _i18n.i18n.translate('xpack.slo.sloEmbeddable.description', {
      defaultMessage: 'Get an overview of your SLO health'
    });
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.slo.sloEmbeddable.displayName', {
      defaultMessage: 'SLO Overview'
    });
  }
  getIconType() {
    return 'visGauge';
  }
}
exports.SloOverviewEmbeddableFactoryDefinition = SloOverviewEmbeddableFactoryDefinition;