"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLO_EMBEDDABLE = exports.SLOEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@tanstack/react-query");
var _rxjs = require("rxjs");
var _common = require("@kbn/kibana-react-plugin/common");
var _history = require("history");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _plugin_context = require("../../../context/plugin_context");
var _slo_overview_grid = require("./slo_overview_grid");
var _slo_overview = require("./slo_overview");
var _group_view = require("./group_view/group_view");
var _edit_slo_overview_panel = require("../../../ui_actions/edit_slo_overview_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLO_EMBEDDABLE = exports.SLO_EMBEDDABLE = 'SLO_EMBEDDABLE';
class SLOEmbeddable extends _public.Embeddable {
  constructor(deps, initialInput, parent) {
    super(initialInput, {}, parent);
    (0, _defineProperty2.default)(this, "type", SLO_EMBEDDABLE);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "reloadSubject", void 0);
    (0, _defineProperty2.default)(this, "reloadGroupSubject", void 0);
    (0, _defineProperty2.default)(this, "subscription", void 0);
    this.deps = deps;
    this.reloadSubject = new _rxjs.Subject();
    this.reloadGroupSubject = new _rxjs.Subject();
    this.setTitle(this.input.title || _i18n.i18n.translate('xpack.slo.sloEmbeddable.displayTitle', {
      defaultMessage: 'SLO Overview'
    }));
    this.subscription = this.getInput$().subscribe(input => {
      this.reloadGroupSubject.next(input);
    });
  }
  setTitle(title) {
    this.updateInput({
      title
    });
  }
  onRenderComplete() {
    this.renderComplete.dispatchComplete();
  }
  render(node) {
    super.render(node);
    this.node = node;
    // required for the export feature to work
    this.node.setAttribute('data-shared-item', '');
    const {
      sloId,
      sloInstanceId,
      showAllGroupByInstances,
      overviewMode,
      groupFilters,
      remoteName
    } = this.getInput();
    const queryClient = new _reactQuery.QueryClient();
    const {
      observabilityRuleTypeRegistry
    } = this.deps.observability;
    const I18nContext = this.deps.i18n.Context;
    const renderOverview = () => {
      if (overviewMode === 'groups') {
        var _groupFilters$groupBy, _groupFilters$kqlQuer, _groupFilters$groups;
        const groupBy = (_groupFilters$groupBy = groupFilters === null || groupFilters === void 0 ? void 0 : groupFilters.groupBy) !== null && _groupFilters$groupBy !== void 0 ? _groupFilters$groupBy : 'status';
        const kqlQuery = (_groupFilters$kqlQuer = groupFilters === null || groupFilters === void 0 ? void 0 : groupFilters.kqlQuery) !== null && _groupFilters$kqlQuer !== void 0 ? _groupFilters$kqlQuer : '';
        const groups = (_groupFilters$groups = groupFilters === null || groupFilters === void 0 ? void 0 : groupFilters.groups) !== null && _groupFilters$groups !== void 0 ? _groupFilters$groups : [];
        return /*#__PURE__*/_react.default.createElement(Wrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          justifyContent: "flexEnd",
          wrap: true,
          css: `
                margin-bottom: 20px;
              `
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => {
            const trigger = this.deps.uiActions.getTrigger(_public.CONTEXT_MENU_TRIGGER);
            this.deps.uiActions.getAction(_edit_slo_overview_panel.EDIT_SLO_OVERVIEW_ACTION).execute({
              trigger,
              embeddable: this
            });
          },
          "data-test-subj": "o11ySloAlertsWrapperSlOsIncludedLink"
        }, _i18n.i18n.translate('xpack.slo.overviewEmbeddable.editCriteriaLabel', {
          defaultMessage: 'Edit criteria'
        })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_group_view.GroupSloView, {
          sloView: "cardView",
          groupBy: groupBy,
          groups: groups,
          kqlQuery: kqlQuery,
          filters: groupFilters === null || groupFilters === void 0 ? void 0 : groupFilters.filters,
          reloadGroupSubject: this.reloadGroupSubject
        })));
      } else {
        return /*#__PURE__*/_react.default.createElement(_slo_overview.SloOverview, {
          onRenderComplete: () => this.onRenderComplete(),
          sloId: sloId,
          sloInstanceId: sloInstanceId,
          reloadSubject: this.reloadSubject,
          showAllGroupByInstances: showAllGroupByInstances,
          remoteName: remoteName
        });
      }
    };
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
      history: (0, _history.createBrowserHistory)()
    }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
      darkMode: true
    }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
      theme: this.deps.theme
    }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
      services: this.deps
    }, /*#__PURE__*/_react.default.createElement(_plugin_context.PluginContext.Provider, {
      value: {
        observabilityRuleTypeRegistry
      }
    }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
      client: queryClient
    }, showAllGroupByInstances ? /*#__PURE__*/_react.default.createElement(_slo_overview_grid.SloCardChartList, {
      sloId: sloId
    }) : renderOverview()))))))), node);
  }
  getSloOverviewConfig() {
    return this.getInput();
  }
  updateSloOverviewConfig(next) {
    this.updateInput(next);
  }
  reload() {
    var _this$reloadGroupSubj;
    this.reloadSubject.next(true);
    (_this$reloadGroupSubj = this.reloadGroupSubject) === null || _this$reloadGroupSubj === void 0 ? void 0 : _this$reloadGroupSubj.next(undefined);
  }
  destroy() {
    super.destroy();
    this.subscription.unsubscribe();
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
  }
}
exports.SLOEmbeddable = SLOEmbeddable;
const Wrapper = _styledComponents.default.div`
  width: 100%;
  padding: 5px 15px;
  overflow: scroll;

  .euiAccordion__buttonContent {
    min-width: 100px;
  }
`;