"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloConfiguration = SloConfiguration;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _sloSchema = require("@kbn/slo-schema");
var _i18n = require("@kbn/i18n");
var _slo_selector = require("../alerts/slo_selector");
var _slo_group_filters = require("./group_view/slo_group_filters");
var _overview_mode_selector = require("./overview_mode_selector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SingleSloConfiguration({
  overviewMode,
  onCreate,
  onCancel
}) {
  const [selectedSlo, setSelectedSlo] = (0, _react.useState)();
  const [showAllGroupByInstances, setShowAllGroupByInstances] = (0, _react.useState)(false);
  const [hasError, setHasError] = (0, _react.useState)(false);
  const hasGroupBy = selectedSlo && selectedSlo.sloInstanceId !== _sloSchema.ALL_VALUE;
  const onConfirmClick = () => onCreate({
    showAllGroupByInstances,
    sloId: selectedSlo === null || selectedSlo === void 0 ? void 0 : selectedSlo.sloId,
    sloInstanceId: selectedSlo === null || selectedSlo === void 0 ? void 0 : selectedSlo.sloInstanceId,
    remoteName: selectedSlo === null || selectedSlo === void 0 ? void 0 : selectedSlo.remoteName,
    overviewMode
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_slo_selector.SloSelector, {
    singleSelection: true,
    hasError: hasError,
    onSelected: slo => {
      setHasError(slo === undefined);
      if (slo && 'id' in slo) {
        var _slo$remote;
        setSelectedSlo({
          sloId: slo.id,
          sloInstanceId: slo.instanceId,
          remoteName: (_slo$remote = slo.remote) === null || _slo$remote === void 0 ? void 0 : _slo$remote.remoteName
        });
      }
    }
  }))), hasGroupBy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.slo.sloConfiguration.euiSwitch.showAllGroupByLabel', {
      defaultMessage: 'Show all related group-by instances'
    }),
    checked: showAllGroupByInstances,
    onChange: e => {
      setShowAllGroupByInstances(e.target.checked);
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "sloCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEmbeddable.config.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "sloConfirmButton",
    isDisabled: !selectedSlo || hasError,
    onClick: onConfirmClick,
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.overviewEmbeddableSlo.config.confirmButtonLabel",
    defaultMessage: "Save"
  })))));
}
function GroupSloConfiguration({
  overviewMode,
  onCreate,
  onCancel,
  initialInput
}) {
  var _initialInput$groupFi, _initialInput$groupFi2, _initialInput$groupFi3, _initialInput$groupFi4;
  const [selectedGroupFilters, setSelectedGroupFilters] = (0, _react.useState)({
    groupBy: (_initialInput$groupFi = initialInput === null || initialInput === void 0 ? void 0 : initialInput.groupFilters.groupBy) !== null && _initialInput$groupFi !== void 0 ? _initialInput$groupFi : 'status',
    filters: (_initialInput$groupFi2 = initialInput === null || initialInput === void 0 ? void 0 : initialInput.groupFilters.filters) !== null && _initialInput$groupFi2 !== void 0 ? _initialInput$groupFi2 : [],
    kqlQuery: (_initialInput$groupFi3 = initialInput === null || initialInput === void 0 ? void 0 : initialInput.groupFilters.kqlQuery) !== null && _initialInput$groupFi3 !== void 0 ? _initialInput$groupFi3 : '',
    groups: (_initialInput$groupFi4 = initialInput === null || initialInput === void 0 ? void 0 : initialInput.groupFilters.groups) !== null && _initialInput$groupFi4 !== void 0 ? _initialInput$groupFi4 : []
  });
  const onConfirmClick = () => onCreate({
    groupFilters: selectedGroupFilters,
    overviewMode
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    className: "sloOverviewEmbeddable"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_slo_group_filters.SloGroupFilters, {
    selectedFilters: selectedGroupFilters,
    onSelected: (prop, value) => {
      setSelectedGroupFilters(prevState => ({
        ...prevState,
        [prop]: value
      }));
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "sloCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEmbeddable.config.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "sloConfirmButton",
    onClick: onConfirmClick,
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.overviewEmbeddableSlo.config.confirmButtonLabel",
    defaultMessage: "Save"
  })))));
}
function SloConfiguration({
  initialInput,
  onCreate,
  onCancel
}) {
  var _initialInput$overvie;
  const [overviewMode, setOverviewMode] = (0, _react.useState)((_initialInput$overvie = initialInput === null || initialInput === void 0 ? void 0 : initialInput.overviewMode) !== null && _initialInput$overvie !== void 0 ? _initialInput$overvie : 'single');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onCancel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.slo.sloEmbeddable.config.sloSelector.headerTitle', {
    defaultMessage: 'SLO configuration'
  })))), (initialInput === null || initialInput === void 0 ? void 0 : initialInput.overviewMode) === undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_overview_mode_selector.OverviewModeSelector, {
    value: overviewMode,
    onChange: mode => setOverviewMode(mode)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })))), overviewMode === 'groups' ? /*#__PURE__*/_react.default.createElement(GroupSloConfiguration, {
    initialInput: initialInput,
    overviewMode: overviewMode,
    onCreate: onCreate,
    onCancel: onCancel
  }) : /*#__PURE__*/_react.default.createElement(SingleSloConfiguration, {
    overviewMode: overviewMode,
    onCreate: onCreate,
    onCancel: onCancel
  }));
}