"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupSloView = GroupSloView;
var _react = _interopRequireWildcard(require("react"));
var _group_view = require("../../../../pages/slos/components/grouped_slos/group_view");
var _build_kql_query = require("./helpers/build_kql_query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function GroupSloView({
  sloView,
  groupBy: initialGroupBy = 'status',
  groups: initialGroups = [],
  kqlQuery: initialKqlQuery = '',
  filters: initialFilters = [],
  reloadGroupSubject
}) {
  const [lastRefreshTime, setLastRefreshTime] = (0, _react.useState)(undefined);
  const [groupBy, setGroupBy] = (0, _react.useState)(initialGroupBy);
  const [kqlQuery, setKqlQuery] = (0, _react.useState)(initialKqlQuery);
  const [filters, setFilters] = (0, _react.useState)(initialFilters);
  const [groups, setGroups] = (0, _react.useState)(initialGroups);
  const combinedKqlQuery = (0, _build_kql_query.buildCombinedKqlQuery)({
    groups,
    groupBy,
    kqlQuery
  });
  (0, _react.useEffect)(() => {
    const subs = reloadGroupSubject === null || reloadGroupSubject === void 0 ? void 0 : reloadGroupSubject.subscribe(input => {
      if (input) {
        var _input$groupFilters$g, _input$groupFilters, _input$groupFilters$k, _input$groupFilters2, _input$groupFilters$f, _input$groupFilters3, _input$groupFilters$g2, _input$groupFilters4;
        const nGroupBy = (_input$groupFilters$g = input === null || input === void 0 ? void 0 : (_input$groupFilters = input.groupFilters) === null || _input$groupFilters === void 0 ? void 0 : _input$groupFilters.groupBy) !== null && _input$groupFilters$g !== void 0 ? _input$groupFilters$g : groupBy;
        setGroupBy(nGroupBy);
        const nKqlInput = (_input$groupFilters$k = input === null || input === void 0 ? void 0 : (_input$groupFilters2 = input.groupFilters) === null || _input$groupFilters2 === void 0 ? void 0 : _input$groupFilters2.kqlQuery) !== null && _input$groupFilters$k !== void 0 ? _input$groupFilters$k : kqlQuery;
        setKqlQuery(nKqlInput);
        const nFilters = (_input$groupFilters$f = input === null || input === void 0 ? void 0 : (_input$groupFilters3 = input.groupFilters) === null || _input$groupFilters3 === void 0 ? void 0 : _input$groupFilters3.filters) !== null && _input$groupFilters$f !== void 0 ? _input$groupFilters$f : filters;
        setFilters(nFilters);
        const nGroups = (_input$groupFilters$g2 = input === null || input === void 0 ? void 0 : (_input$groupFilters4 = input.groupFilters) === null || _input$groupFilters4 === void 0 ? void 0 : _input$groupFilters4.groups) !== null && _input$groupFilters$g2 !== void 0 ? _input$groupFilters$g2 : groups;
        setGroups(nGroups);
      }
      setLastRefreshTime(Date.now());
    });
    return () => {
      subs === null || subs === void 0 ? void 0 : subs.unsubscribe();
    };
  }, [filters, groupBy, groups, kqlQuery, reloadGroupSubject]);
  return /*#__PURE__*/_react.default.createElement(_group_view.GroupView, {
    sloView: sloView,
    groupBy: groupBy,
    groupsFilter: groups,
    kqlQuery: combinedKqlQuery,
    filters: filters,
    lastRefreshTime: lastRefreshTime
  });
}