"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloConfiguration = SloConfiguration;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _slo_selector = require("../alerts/slo_selector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloConfiguration({
  onCreate,
  onCancel
}) {
  const [selectedSlo, setSelectedSlo] = (0, _react.useState)();
  const onConfirmClick = () => onCreate({
    sloId: selectedSlo === null || selectedSlo === void 0 ? void 0 : selectedSlo.sloId,
    sloInstanceId: selectedSlo === null || selectedSlo === void 0 ? void 0 : selectedSlo.sloInstanceId
  });
  const [hasError, setHasError] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onCancel,
    style: {
      minWidth: 550
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('xpack.slo.sloEmbeddable.config.sloSelector.headerTitle', {
    defaultMessage: 'SLO configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_slo_selector.SloSelector, {
    singleSelection: true,
    hasError: hasError,
    onSelected: slo => {
      setHasError(slo === undefined);
      if (slo && 'id' in slo) {
        setSelectedSlo({
          sloId: slo.id,
          sloInstanceId: slo.instanceId
        });
      }
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "sloCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEmbeddable.config.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "sloConfirmButton",
    isDisabled: !selectedSlo || hasError,
    onClick: onConfirmClick,
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.embeddableSlo.config.confirmButtonLabel",
    defaultMessage: "Confirm configurations"
  }))));
}