"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorRateChart = ErrorRateChart;
var _public = require("@kbn/embeddable-plugin/public");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _kibana_react = require("../../../utils/kibana_react");
var _get_delay_in_seconds_from_slo = require("../../../utils/slo/get_delay_in_seconds_from_slo");
var _use_lens_definition = require("./use_lens_definition");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ErrorRateChart({
  slo,
  dataTimeRange,
  threshold,
  alertTimeRange,
  showErrorRateAsLine,
  annotations
}) {
  const {
    lens: {
      EmbeddableComponent
    }
  } = (0, _kibana_react.useKibana)().services;
  const lensDef = (0, _use_lens_definition.useLensDefinition)(slo, threshold, alertTimeRange, annotations, showErrorRateAsLine);
  const delayInSeconds = (0, _get_delay_in_seconds_from_slo.getDelayInSecondsFromSLO)(slo);
  const from = (0, _moment.default)(dataTimeRange.from).subtract(delayInSeconds, 'seconds').toISOString();
  const to = (0, _moment.default)(dataTimeRange.to).subtract(delayInSeconds, 'seconds').toISOString();
  return /*#__PURE__*/_react.default.createElement(EmbeddableComponent, {
    id: "sloErrorRateChart",
    style: {
      height: 190
    },
    timeRange: {
      from,
      to
    },
    attributes: lensDef,
    viewMode: _public.ViewMode.VIEW,
    noPadding: true
  });
}