"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BurnRates = BurnRates;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _use_fetch_slo_burn_rates = require("../../../hooks/use_fetch_slo_burn_rates");
var _error_rate_chart = require("../error_rate_chart");
var _burn_rate = require("./burn_rate");
var _technical_preview_badge = require("../../technical_preview_badge");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getWindowsFromOptions(opts) {
  return opts.map(opt => ({
    name: opt.windowName,
    duration: `${opt.duration}h`
  }));
}
function BurnRates({
  slo,
  isAutoRefreshing,
  burnRateOptions
}) {
  var _data$burnRates$find;
  const [burnRateOption, setBurnRateOption] = (0, _react.useState)(burnRateOptions[0]);
  const {
    isLoading,
    data
  } = (0, _use_fetch_slo_burn_rates.useFetchSloBurnRates)({
    slo,
    shouldRefetch: isAutoRefreshing,
    windows: getWindowsFromOptions(burnRateOptions)
  });
  (0, _react.useEffect)(() => {
    if (burnRateOptions.length) {
      setBurnRateOption(burnRateOptions[0]);
    }
  }, [burnRateOptions]);
  const onBurnRateOptionChange = optionId => {
    var _burnRateOptions$find;
    const selected = (_burnRateOptions$find = burnRateOptions.find(opt => opt.id === optionId)) !== null && _burnRateOptions$find !== void 0 ? _burnRateOptions$find : burnRateOptions[0];
    setBurnRateOption(selected);
  };
  const dataTimeRange = {
    from: (0, _moment.default)().subtract(burnRateOption.duration, 'hour').toDate(),
    to: new Date()
  };
  const threshold = burnRateOption.threshold;
  const burnRate = data === null || data === void 0 ? void 0 : (_data$burnRates$find = data.burnRates.find(curr => curr.name === burnRateOption.windowName)) === null || _data$burnRates$find === void 0 ? void 0 : _data$burnRates$find.burnRate;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "transparent",
    hasBorder: true,
    "data-test-subj": "burnRatePanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.slo.burnRate.title', {
    defaultMessage: 'Burn rate'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.slo.burnRate.timeRangeBtnLegend', {
      defaultMessage: 'Select the time range'
    }),
    options: burnRateOptions.map(opt => ({
      id: opt.id,
      label: opt.label
    })),
    idSelected: burnRateOption.id,
    onChange: onBurnRateOptionChange,
    buttonSize: "compressed"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_burn_rate.BurnRate, {
    threshold: threshold,
    burnRate: burnRate,
    slo: slo,
    isLoading: isLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_error_rate_chart.ErrorRateChart, {
    slo: slo,
    dataTimeRange: dataTimeRange,
    threshold: threshold
  })))));
}