"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAutoRefreshStorage = useAutoRefreshStorage;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AUTO_REFRESH_STORAGE_KEY = 'slo.auto_refresh';
function useAutoRefreshStorage() {
  if (!localStorage) {
    return {
      storeAutoRefreshState: () => {},
      getAutoRefreshState: () => true
    };
  }
  return {
    storeAutoRefreshState: newValue => {
      localStorage.setItem(AUTO_REFRESH_STORAGE_KEY, JSON.stringify(newValue));
    },
    getAutoRefreshState: () => {
      const value = localStorage.getItem(AUTO_REFRESH_STORAGE_KEY);
      if (value === null) return true;
      return Boolean(JSON.parse(value));
    }
  };
}