"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderMenu = HeaderMenu;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _kibana_react = require("../../utils/kibana_react");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _paths = require("../../../common/locators/paths");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HeaderMenu() {
  const {
    http,
    theme
  } = (0, _kibana_react.useKibana)().services;
  const {
    appMountParameters,
    isServerless
  } = (0, _use_plugin_context.usePluginContext)();
  return /*#__PURE__*/_react.default.createElement(_public.HeaderMenuPortal, {
    setHeaderActionMenu: appMountParameters === null || appMountParameters === void 0 ? void 0 : appMountParameters.setHeaderActionMenu,
    theme$: theme.theme$
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    href: http.basePath.prepend('/app/integrations/browse'),
    iconType: "indexOpen"
  }, _i18n.i18n.translate('xpack.slo.headerMenu.addData', {
    defaultMessage: 'Add integrations'
  })), !isServerless && /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    href: http.basePath.prepend(`${_paths.SLOS_BASE_PATH}${_paths.SLO_SETTINGS_PATH}`),
    iconType: "gear"
  }, _i18n.i18n.translate('xpack.slo.headerMenu.settings', {
    defaultMessage: 'Settings'
  }))))));
}