"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _public2 = require("@kbn/core/public");
var _reactQuery = require("@tanstack/react-query");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _common = require("@kbn/kibana-react-plugin/common");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _public3 = require("@kbn/kibana-utils-plugin/public");
var _i18n = require("@kbn/i18n");
var _use_plugin_context = require("./hooks/use_plugin_context");
var _plugin_context = require("./context/plugin_context");
var _routes = require("./routes/routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function App() {
  const {
    isServerless
  } = (0, _use_plugin_context.usePluginContext)();
  const routes = (0, _routes.getRoutes)(isServerless);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, Object.keys(routes).map(path => {
    const {
      handler,
      exact
    } = routes[path];
    const Wrapper = () => {
      return handler();
    };
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      key: path,
      path: path,
      exact: exact,
      component: Wrapper
    });
  })));
}
const renderApp = ({
  core,
  plugins,
  appMountParameters,
  ObservabilityPageTemplate,
  usageCollection,
  isDev,
  kibanaVersion,
  isServerless,
  observabilityRuleTypeRegistry,
  experimentalFeatures
}) => {
  var _usageCollection$comp, _plugins$cloud$CloudC, _plugins$cloud, _plugins$presentation, _plugins$presentation2, _plugins$observabilit;
  const {
    element,
    history,
    theme$
  } = appMountParameters;
  const i18nCore = core.i18n;
  const isDarkMode = core.theme.getTheme().darkMode;

  // ensure all divs are .kbnAppWrappers
  element.classList.add(_public2.APP_WRAPPER_CLASS);
  const queryClient = new _reactQuery.QueryClient();
  const ApplicationUsageTrackingProvider = (_usageCollection$comp = usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.components.ApplicationUsageTrackingProvider) !== null && _usageCollection$comp !== void 0 ? _usageCollection$comp : _react.default.Fragment;
  const CloudProvider = (_plugins$cloud$CloudC = (_plugins$cloud = plugins.cloud) === null || _plugins$cloud === void 0 ? void 0 : _plugins$cloud.CloudContextProvider) !== null && _plugins$cloud$CloudC !== void 0 ? _plugins$cloud$CloudC : _react.default.Fragment;
  const PresentationContextProvider = (_plugins$presentation = (_plugins$presentation2 = plugins.presentationUtil) === null || _plugins$presentation2 === void 0 ? void 0 : _plugins$presentation2.ContextProvider) !== null && _plugins$presentation !== void 0 ? _plugins$presentation : _react.default.Fragment;
  const unregisterPrompts = (_plugins$observabilit = plugins.observabilityAIAssistant) === null || _plugins$observabilit === void 0 ? void 0 : _plugins$observabilit.service.setScreenContext({
    starterPrompts: [{
      title: _i18n.i18n.translate('xpack.slo.starterPrompts.whatAreSlos.title', {
        defaultMessage: 'Getting started'
      }),
      prompt: _i18n.i18n.translate('xpack.slo.starterPrompts.whatAreSlos.prompt', {
        defaultMessage: 'What are SLOs?'
      }),
      icon: 'bullseye'
    }, {
      title: _i18n.i18n.translate('xpack.slo.starterPrompts.canYouCreateAnSlo.title', {
        defaultMessage: 'Getting started'
      }),
      prompt: _i18n.i18n.translate('xpack.slo.starterPrompts.canYouCreateAnSlo.prompt', {
        defaultMessage: 'Can you create an SLO?'
      }),
      icon: 'questionInCircle'
    }]
  });
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(PresentationContextProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(ApplicationUsageTrackingProvider, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: {
      theme$
    }
  }, /*#__PURE__*/_react.default.createElement(CloudProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins,
      storage: new _public3.Storage(localStorage),
      isDev,
      kibanaVersion,
      isServerless
    }
  }, /*#__PURE__*/_react.default.createElement(_plugin_context.PluginContext.Provider, {
    value: {
      isDev,
      isServerless,
      appMountParameters,
      ObservabilityPageTemplate,
      observabilityRuleTypeRegistry,
      experimentalFeatures
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: isDarkMode
  }, /*#__PURE__*/_react.default.createElement(i18nCore.Context, null, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: core,
    "data-test-subj": "observabilityMainContainer"
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(App, null))))))))))))), element);
  return () => {
    // This needs to be present to fix https://github.com/elastic/kibana/issues/155704
    // as the Overview page renders the UX Section component. That component renders a Lens embeddable
    // via the ExploratoryView app, which uses search sessions. Therefore on unmounting we need to clear
    // these sessions.
    plugins.data.search.session.clear();
    unregisterPrompts === null || unregisterPrompts === void 0 ? void 0 : unregisterPrompts();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;