"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Page = void 0;
var React = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _empty_prompt = require("./empty_prompt");
var _spinner = require("./spinner");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const Page = ({
  manager,
  homeHref,
  customBranding,
  docTitle,
  theme
}) => {
  const error = (0, _useObservable.default)(manager.error$);
  const hasCustomBranding = (0, _useObservable.default)(customBranding.hasCustomBranding$);
  if (error) {
    return /*#__PURE__*/React.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
      theme: theme
    }, /*#__PURE__*/React.createElement(_eui.EuiPageTemplate, null, /*#__PURE__*/React.createElement(_empty_prompt.RedirectEmptyPrompt, {
      docTitle: docTitle,
      error: error,
      homeHref: homeHref
    })));
  }
  return /*#__PURE__*/React.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: theme
  }, /*#__PURE__*/React.createElement(_eui.EuiPageTemplate, null, /*#__PURE__*/React.createElement(_spinner.Spinner, {
    showPlainSpinner: Boolean(hasCustomBranding)
  })));
};
exports.Page = Page;